// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of tags on a dataset to set row-level security.
 */
public class RowLevelPermissionTagConfiguration private constructor(builder: Builder) {
    /**
     * The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.Status? = builder.status
    /**
     * A list of tag configuration rules to apply to a dataset. All tag configurations have the OR condition. Tags within each tile will be joined (AND). At least one rule in this structure must have all tag values assigned to it to apply Row-level security (RLS) to the dataset.
     */
    public val tagRuleConfigurations: List<List<String>>? = builder.tagRuleConfigurations
    /**
     * A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.
     */
    public val tagRules: List<RowLevelPermissionTagRule> = requireNotNull(builder.tagRules) { "A non-null value must be provided for tagRules" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RowLevelPermissionTagConfiguration(")
        append("status=$status,")
        append("tagRuleConfigurations=$tagRuleConfigurations,")
        append("tagRules=$tagRules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        result = 31 * result + (tagRuleConfigurations?.hashCode() ?: 0)
        result = 31 * result + (tagRules.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RowLevelPermissionTagConfiguration

        if (status != other.status) return false
        if (tagRuleConfigurations != other.tagRuleConfigurations) return false
        if (tagRules != other.tagRules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.Status? = null
        /**
         * A list of tag configuration rules to apply to a dataset. All tag configurations have the OR condition. Tags within each tile will be joined (AND). At least one rule in this structure must have all tag values assigned to it to apply Row-level security (RLS) to the dataset.
         */
        public var tagRuleConfigurations: List<List<String>>? = null
        /**
         * A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.
         */
        public var tagRules: List<RowLevelPermissionTagRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration) : this() {
            this.status = x.status
            this.tagRuleConfigurations = x.tagRuleConfigurations
            this.tagRules = x.tagRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration = RowLevelPermissionTagConfiguration(this)

        internal fun correctErrors(): Builder {
            if (tagRules == null) tagRules = emptyList()
            return this
        }
    }
}
