// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Permission for the resource.
 */
public class ResourcePermission private constructor(builder: Builder) {
    /**
     * The IAM action to grant or revoke permissions on.
     */
    public val actions: List<String> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * The Amazon Resource Name (ARN) of the principal. This can be one of the following:
     * + The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)
     * + The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)
     * + The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across Amazon Web Services accounts. (This is less common.)
     */
    public val principal: kotlin.String = requireNotNull(builder.principal) { "A non-null value must be provided for principal" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ResourcePermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourcePermission(")
        append("actions=$actions,")
        append("principal=$principal")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (principal.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourcePermission

        if (actions != other.actions) return false
        if (principal != other.principal) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ResourcePermission = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IAM action to grant or revoke permissions on.
         */
        public var actions: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:
         * + The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)
         * + The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)
         * + The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across Amazon Web Services accounts. (This is less common.)
         */
        public var principal: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ResourcePermission) : this() {
            this.actions = x.actions
            this.principal = x.principal
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ResourcePermission = ResourcePermission(this)

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            if (principal == null) principal = ""
            return this
        }
    }
}
