// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `RelativeDatesFilter` filters relative dates values.
 */
public class RelativeDatesFilter private constructor(builder: Builder) {
    /**
     * The date configuration of the filter.
     */
    public val anchorDateConfiguration: aws.sdk.kotlin.services.quicksight.model.AnchorDateConfiguration? = builder.anchorDateConfiguration
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * The configuration for the exclude period of the filter.
     */
    public val excludePeriodConfiguration: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration? = builder.excludePeriodConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * The minimum granularity (period granularity) of the relative dates filter.
     */
    public val minimumGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = builder.minimumGranularity
    /**
     * This option determines how null values should be treated when filtering data.
     * + `ALL_VALUES`: Include null values in filtered results.
     * + `NULLS_ONLY`: Only include null values in filtered results.
     * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
     */
    public val nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption = requireNotNull(builder.nullOption) { "A non-null value must be provided for nullOption" }
    /**
     * The parameter whose value should be used for the filter value.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The range date type of the filter. Choose one of the options below:
     * + `PREVIOUS`
     * + `THIS`
     * + `LAST`
     * + `NOW`
     * + `NEXT`
     */
    public val relativeDateType: aws.sdk.kotlin.services.quicksight.model.RelativeDateType = requireNotNull(builder.relativeDateType) { "A non-null value must be provided for relativeDateType" }
    /**
     * The date value of the filter.
     */
    public val relativeDateValue: kotlin.Int? = builder.relativeDateValue
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity = requireNotNull(builder.timeGranularity) { "A non-null value must be provided for timeGranularity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelativeDatesFilter(")
        append("anchorDateConfiguration=$anchorDateConfiguration,")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("excludePeriodConfiguration=$excludePeriodConfiguration,")
        append("filterId=$filterId,")
        append("minimumGranularity=$minimumGranularity,")
        append("nullOption=$nullOption,")
        append("parameterName=$parameterName,")
        append("relativeDateType=$relativeDateType,")
        append("relativeDateValue=$relativeDateValue,")
        append("timeGranularity=$timeGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anchorDateConfiguration?.hashCode() ?: 0
        result = 31 * result + (column?.hashCode() ?: 0)
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (excludePeriodConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (minimumGranularity?.hashCode() ?: 0)
        result = 31 * result + (nullOption.hashCode())
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (relativeDateType.hashCode())
        result = 31 * result + (relativeDateValue ?: 0)
        result = 31 * result + (timeGranularity.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelativeDatesFilter

        if (anchorDateConfiguration != other.anchorDateConfiguration) return false
        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (excludePeriodConfiguration != other.excludePeriodConfiguration) return false
        if (filterId != other.filterId) return false
        if (minimumGranularity != other.minimumGranularity) return false
        if (nullOption != other.nullOption) return false
        if (parameterName != other.parameterName) return false
        if (relativeDateType != other.relativeDateType) return false
        if (relativeDateValue != other.relativeDateValue) return false
        if (timeGranularity != other.timeGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date configuration of the filter.
         */
        public var anchorDateConfiguration: aws.sdk.kotlin.services.quicksight.model.AnchorDateConfiguration? = null
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * The configuration for the exclude period of the filter.
         */
        public var excludePeriodConfiguration: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * The minimum granularity (period granularity) of the relative dates filter.
         */
        public var minimumGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null
        /**
         * This option determines how null values should be treated when filtering data.
         * + `ALL_VALUES`: Include null values in filtered results.
         * + `NULLS_ONLY`: Only include null values in filtered results.
         * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
         */
        public var nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption? = null
        /**
         * The parameter whose value should be used for the filter value.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The range date type of the filter. Choose one of the options below:
         * + `PREVIOUS`
         * + `THIS`
         * + `LAST`
         * + `NOW`
         * + `NEXT`
         */
        public var relativeDateType: aws.sdk.kotlin.services.quicksight.model.RelativeDateType? = null
        /**
         * The date value of the filter.
         */
        public var relativeDateValue: kotlin.Int? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter) : this() {
            this.anchorDateConfiguration = x.anchorDateConfiguration
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.excludePeriodConfiguration = x.excludePeriodConfiguration
            this.filterId = x.filterId
            this.minimumGranularity = x.minimumGranularity
            this.nullOption = x.nullOption
            this.parameterName = x.parameterName
            this.relativeDateType = x.relativeDateType
            this.relativeDateValue = x.relativeDateValue
            this.timeGranularity = x.timeGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter = RelativeDatesFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnchorDateConfiguration] inside the given [block]
         */
        public fun anchorDateConfiguration(block: aws.sdk.kotlin.services.quicksight.model.AnchorDateConfiguration.Builder.() -> kotlin.Unit) {
            this.anchorDateConfiguration = aws.sdk.kotlin.services.quicksight.model.AnchorDateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration] inside the given [block]
         */
        public fun excludePeriodConfiguration(block: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration.Builder.() -> kotlin.Unit) {
            this.excludePeriodConfiguration = aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            if (nullOption == null) nullOption = FilterNullOption.SdkUnknown("no value provided")
            if (relativeDateType == null) relativeDateType = RelativeDateType.SdkUnknown("no value provided")
            if (timeGranularity == null) timeGranularity = TimeGranularity.SdkUnknown("no value provided")
            return this
        }
    }
}
