// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the Amazon QuickSight console that you want to embed.
 */
public class RegisteredUserQuickSightConsoleEmbeddingConfiguration private constructor(builder: Builder) {
    /**
     * The embedding configuration of an embedded Amazon QuickSight console.
     */
    public val featureConfigurations: aws.sdk.kotlin.services.quicksight.model.RegisteredUserConsoleFeatureConfigurations? = builder.featureConfigurations
    /**
     * The initial URL path for the Amazon QuickSight console. `InitialPath` is required.
     *
     * The entry point URL is constrained to the following paths:
     * + `/start`
     * + `/start/analyses`
     * + `/start/dashboards`
     * + `/start/favorites`
     * + `/dashboards/DashboardId`. *DashboardId* is the actual ID key from the Amazon QuickSight console URL of the dashboard.
     * + `/analyses/AnalysisId`. *AnalysisId* is the actual ID key from the Amazon QuickSight console URL of the analysis.
     */
    public val initialPath: kotlin.String? = builder.initialPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisteredUserQuickSightConsoleEmbeddingConfiguration(")
        append("featureConfigurations=$featureConfigurations,")
        append("initialPath=$initialPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureConfigurations?.hashCode() ?: 0
        result = 31 * result + (initialPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisteredUserQuickSightConsoleEmbeddingConfiguration

        if (featureConfigurations != other.featureConfigurations) return false
        if (initialPath != other.initialPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The embedding configuration of an embedded Amazon QuickSight console.
         */
        public var featureConfigurations: aws.sdk.kotlin.services.quicksight.model.RegisteredUserConsoleFeatureConfigurations? = null
        /**
         * The initial URL path for the Amazon QuickSight console. `InitialPath` is required.
         *
         * The entry point URL is constrained to the following paths:
         * + `/start`
         * + `/start/analyses`
         * + `/start/dashboards`
         * + `/start/favorites`
         * + `/dashboards/DashboardId`. *DashboardId* is the actual ID key from the Amazon QuickSight console URL of the dashboard.
         * + `/analyses/AnalysisId`. *AnalysisId* is the actual ID key from the Amazon QuickSight console URL of the analysis.
         */
        public var initialPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration) : this() {
            this.featureConfigurations = x.featureConfigurations
            this.initialPath = x.initialPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration = RegisteredUserQuickSightConsoleEmbeddingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserConsoleFeatureConfigurations] inside the given [block]
         */
        public fun featureConfigurations(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserConsoleFeatureConfigurations.Builder.() -> kotlin.Unit) {
            this.featureConfigurations = aws.sdk.kotlin.services.quicksight.model.RegisteredUserConsoleFeatureConfigurations.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
