// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The type of experience you want to embed. For registered users, you can embed Amazon QuickSight dashboards or the Amazon QuickSight console.
 *
 * Exactly one of the experience configurations is required. You can choose `Dashboard` or `QuickSightConsole`. You cannot choose more than one experience configuration.
 */
public class RegisteredUserEmbeddingExperienceConfiguration private constructor(builder: Builder) {
    /**
     * The configuration details for providing a dashboard embedding experience.
     */
    public val dashboard: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardEmbeddingConfiguration? = builder.dashboard
    /**
     * The type of embedding experience. In this case, Amazon QuickSight visuals.
     */
    public val dashboardVisual: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardVisualEmbeddingConfiguration? = builder.dashboardVisual
    /**
     * The configuration details for embedding the Generative Q&A experience.
     *
     * For more information about embedding the Generative Q&A experience, see [Embedding Overview](https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html) in the *Amazon QuickSight User Guide*.
     */
    public val generativeQnA: aws.sdk.kotlin.services.quicksight.model.RegisteredUserGenerativeQnAEmbeddingConfiguration? = builder.generativeQnA
    /**
     * The configuration details for embedding the Q search bar.
     *
     * For more information about embedding the Q search bar, see [Embedding Overview](https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html) in the *Amazon QuickSight User Guide*.
     */
    public val qSearchBar: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQSearchBarEmbeddingConfiguration? = builder.qSearchBar
    /**
     * The configuration details for providing each Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html) in the *Amazon QuickSight User Guide*.
     *
     * Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> ` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
     * + [Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html)
     * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public val quickSightConsole: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration? = builder.quickSightConsole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisteredUserEmbeddingExperienceConfiguration(")
        append("dashboard=$dashboard,")
        append("dashboardVisual=$dashboardVisual,")
        append("generativeQnA=$generativeQnA,")
        append("qSearchBar=$qSearchBar,")
        append("quickSightConsole=$quickSightConsole")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboard?.hashCode() ?: 0
        result = 31 * result + (dashboardVisual?.hashCode() ?: 0)
        result = 31 * result + (generativeQnA?.hashCode() ?: 0)
        result = 31 * result + (qSearchBar?.hashCode() ?: 0)
        result = 31 * result + (quickSightConsole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisteredUserEmbeddingExperienceConfiguration

        if (dashboard != other.dashboard) return false
        if (dashboardVisual != other.dashboardVisual) return false
        if (generativeQnA != other.generativeQnA) return false
        if (qSearchBar != other.qSearchBar) return false
        if (quickSightConsole != other.quickSightConsole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration details for providing a dashboard embedding experience.
         */
        public var dashboard: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardEmbeddingConfiguration? = null
        /**
         * The type of embedding experience. In this case, Amazon QuickSight visuals.
         */
        public var dashboardVisual: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardVisualEmbeddingConfiguration? = null
        /**
         * The configuration details for embedding the Generative Q&A experience.
         *
         * For more information about embedding the Generative Q&A experience, see [Embedding Overview](https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html) in the *Amazon QuickSight User Guide*.
         */
        public var generativeQnA: aws.sdk.kotlin.services.quicksight.model.RegisteredUserGenerativeQnAEmbeddingConfiguration? = null
        /**
         * The configuration details for embedding the Q search bar.
         *
         * For more information about embedding the Q search bar, see [Embedding Overview](https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html) in the *Amazon QuickSight User Guide*.
         */
        public var qSearchBar: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQSearchBarEmbeddingConfiguration? = null
        /**
         * The configuration details for providing each Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html) in the *Amazon QuickSight User Guide*.
         *
         * Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> ` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
         * + [Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html)
         * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
         *
         * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
         */
        public var quickSightConsole: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration) : this() {
            this.dashboard = x.dashboard
            this.dashboardVisual = x.dashboardVisual
            this.generativeQnA = x.generativeQnA
            this.qSearchBar = x.qSearchBar
            this.quickSightConsole = x.quickSightConsole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration = RegisteredUserEmbeddingExperienceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardEmbeddingConfiguration] inside the given [block]
         */
        public fun dashboard(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardEmbeddingConfiguration.Builder.() -> kotlin.Unit) {
            this.dashboard = aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardEmbeddingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardVisualEmbeddingConfiguration] inside the given [block]
         */
        public fun dashboardVisual(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardVisualEmbeddingConfiguration.Builder.() -> kotlin.Unit) {
            this.dashboardVisual = aws.sdk.kotlin.services.quicksight.model.RegisteredUserDashboardVisualEmbeddingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserGenerativeQnAEmbeddingConfiguration] inside the given [block]
         */
        public fun generativeQnA(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserGenerativeQnAEmbeddingConfiguration.Builder.() -> kotlin.Unit) {
            this.generativeQnA = aws.sdk.kotlin.services.quicksight.model.RegisteredUserGenerativeQnAEmbeddingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserQSearchBarEmbeddingConfiguration] inside the given [block]
         */
        public fun qSearchBar(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQSearchBarEmbeddingConfiguration.Builder.() -> kotlin.Unit) {
            this.qSearchBar = aws.sdk.kotlin.services.quicksight.model.RegisteredUserQSearchBarEmbeddingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration] inside the given [block]
         */
        public fun quickSightConsole(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder.() -> kotlin.Unit) {
            this.quickSightConsole = aws.sdk.kotlin.services.quicksight.model.RegisteredUserQuickSightConsoleEmbeddingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
