// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A customer managed key structure that contains the information listed below:
 * + `KeyArn` - The ARN of a KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.
 * + `DefaultKey` - Indicates whether the current key is set as the default key for encryption and decryption use.
 */
public class RegisteredCustomerManagedKey private constructor(builder: Builder) {
    /**
     * Indicates whether a `RegisteredCustomerManagedKey` is set as the default key for encryption and decryption use.
     */
    public val defaultKey: kotlin.Boolean = builder.defaultKey
    /**
     * The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.
     */
    public val keyArn: kotlin.String? = builder.keyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RegisteredCustomerManagedKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisteredCustomerManagedKey(")
        append("defaultKey=$defaultKey,")
        append("keyArn=$keyArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultKey.hashCode()
        result = 31 * result + (keyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisteredCustomerManagedKey

        if (defaultKey != other.defaultKey) return false
        if (keyArn != other.keyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RegisteredCustomerManagedKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether a `RegisteredCustomerManagedKey` is set as the default key for encryption and decryption use.
         */
        public var defaultKey: kotlin.Boolean = false
        /**
         * The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.
         */
        public var keyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RegisteredCustomerManagedKey) : this() {
            this.defaultKey = x.defaultKey
            this.keyArn = x.keyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RegisteredCustomerManagedKey = RegisteredCustomerManagedKey(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
