// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The refresh schedule of a dataset.
 */
public class RefreshSchedule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the refresh schedule.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The type of refresh that a datset undergoes. Valid values are as follows:
     * + `FULL_REFRESH`: A complete refresh of a dataset.
     * + `INCREMENTAL_REFRESH`: A partial refresh of some rows of a dataset, based on the time window specified.
     *
     * For more information on full and incremental refreshes, see [Refreshing SPICE data](https://docs.aws.amazon.com/quicksight/latest/user/refreshing-imported-data.html) in the *Amazon QuickSight User Guide*.
     */
    public val refreshType: aws.sdk.kotlin.services.quicksight.model.IngestionType = requireNotNull(builder.refreshType) { "A non-null value must be provided for refreshType" }
    /**
     * The frequency for the refresh schedule.
     */
    public val scheduleFrequency: aws.sdk.kotlin.services.quicksight.model.RefreshFrequency? = builder.scheduleFrequency
    /**
     * An identifier for the refresh schedule.
     */
    public val scheduleId: kotlin.String = requireNotNull(builder.scheduleId) { "A non-null value must be provided for scheduleId" }
    /**
     * Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
     */
    public val startAfterDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startAfterDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RefreshSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshSchedule(")
        append("arn=$arn,")
        append("refreshType=$refreshType,")
        append("scheduleFrequency=$scheduleFrequency,")
        append("scheduleId=$scheduleId,")
        append("startAfterDateTime=$startAfterDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (refreshType.hashCode())
        result = 31 * result + (scheduleFrequency?.hashCode() ?: 0)
        result = 31 * result + (scheduleId.hashCode())
        result = 31 * result + (startAfterDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshSchedule

        if (arn != other.arn) return false
        if (refreshType != other.refreshType) return false
        if (scheduleFrequency != other.scheduleFrequency) return false
        if (scheduleId != other.scheduleId) return false
        if (startAfterDateTime != other.startAfterDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RefreshSchedule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the refresh schedule.
         */
        public var arn: kotlin.String? = null
        /**
         * The type of refresh that a datset undergoes. Valid values are as follows:
         * + `FULL_REFRESH`: A complete refresh of a dataset.
         * + `INCREMENTAL_REFRESH`: A partial refresh of some rows of a dataset, based on the time window specified.
         *
         * For more information on full and incremental refreshes, see [Refreshing SPICE data](https://docs.aws.amazon.com/quicksight/latest/user/refreshing-imported-data.html) in the *Amazon QuickSight User Guide*.
         */
        public var refreshType: aws.sdk.kotlin.services.quicksight.model.IngestionType? = null
        /**
         * The frequency for the refresh schedule.
         */
        public var scheduleFrequency: aws.sdk.kotlin.services.quicksight.model.RefreshFrequency? = null
        /**
         * An identifier for the refresh schedule.
         */
        public var scheduleId: kotlin.String? = null
        /**
         * Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
         */
        public var startAfterDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RefreshSchedule) : this() {
            this.arn = x.arn
            this.refreshType = x.refreshType
            this.scheduleFrequency = x.scheduleFrequency
            this.scheduleId = x.scheduleId
            this.startAfterDateTime = x.startAfterDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RefreshSchedule = RefreshSchedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RefreshFrequency] inside the given [block]
         */
        public fun scheduleFrequency(block: aws.sdk.kotlin.services.quicksight.model.RefreshFrequency.Builder.() -> kotlin.Unit) {
            this.scheduleFrequency = aws.sdk.kotlin.services.quicksight.model.RefreshFrequency.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (refreshType == null) refreshType = IngestionType.SdkUnknown("no value provided")
            if (scheduleId == null) scheduleId = ""
            return this
        }
    }
}
