// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the interval between each scheduled refresh of a dataset.
 */
public class RefreshFrequency private constructor(builder: Builder) {
    /**
     * The interval between scheduled refreshes. Valid values are as follows:
     * + `MINUTE15`: The dataset refreshes every 15 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.
     * + `MINUTE30`:The dataset refreshes every 30 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.
     * + `HOURLY`: The dataset refreshes every hour. This interval can only be used for one schedule per dataset.
     * + `DAILY`: The dataset refreshes every day.
     * + `WEEKLY`: The dataset refreshes every week.
     * + `MONTHLY`: The dataset refreshes every month.
     */
    public val interval: aws.sdk.kotlin.services.quicksight.model.RefreshInterval = requireNotNull(builder.interval) { "A non-null value must be provided for interval" }
    /**
     * The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly refresh intervals.
     */
    public val refreshOnDay: aws.sdk.kotlin.services.quicksight.model.ScheduleRefreshOnEntity? = builder.refreshOnDay
    /**
     * The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field is not required for schedules that refresh hourly.
     */
    public val timeOfTheDay: kotlin.String? = builder.timeOfTheDay
    /**
     * The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID found on `java.util.time.getAvailableIDs()`.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RefreshFrequency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshFrequency(")
        append("interval=$interval,")
        append("refreshOnDay=$refreshOnDay,")
        append("timeOfTheDay=$timeOfTheDay,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = interval.hashCode()
        result = 31 * result + (refreshOnDay?.hashCode() ?: 0)
        result = 31 * result + (timeOfTheDay?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshFrequency

        if (interval != other.interval) return false
        if (refreshOnDay != other.refreshOnDay) return false
        if (timeOfTheDay != other.timeOfTheDay) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RefreshFrequency = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The interval between scheduled refreshes. Valid values are as follows:
         * + `MINUTE15`: The dataset refreshes every 15 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.
         * + `MINUTE30`:The dataset refreshes every 30 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.
         * + `HOURLY`: The dataset refreshes every hour. This interval can only be used for one schedule per dataset.
         * + `DAILY`: The dataset refreshes every day.
         * + `WEEKLY`: The dataset refreshes every week.
         * + `MONTHLY`: The dataset refreshes every month.
         */
        public var interval: aws.sdk.kotlin.services.quicksight.model.RefreshInterval? = null
        /**
         * The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly refresh intervals.
         */
        public var refreshOnDay: aws.sdk.kotlin.services.quicksight.model.ScheduleRefreshOnEntity? = null
        /**
         * The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field is not required for schedules that refresh hourly.
         */
        public var timeOfTheDay: kotlin.String? = null
        /**
         * The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID found on `java.util.time.getAvailableIDs()`.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RefreshFrequency) : this() {
            this.interval = x.interval
            this.refreshOnDay = x.refreshOnDay
            this.timeOfTheDay = x.timeOfTheDay
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RefreshFrequency = RefreshFrequency(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ScheduleRefreshOnEntity] inside the given [block]
         */
        public fun refreshOnDay(block: aws.sdk.kotlin.services.quicksight.model.ScheduleRefreshOnEntity.Builder.() -> kotlin.Unit) {
            this.refreshOnDay = aws.sdk.kotlin.services.quicksight.model.ScheduleRefreshOnEntity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (interval == null) interval = RefreshInterval.SdkUnknown("no value provided")
            return this
        }
    }
}
