// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters for Amazon Redshift. The `ClusterId` field can be blank if `Host` and `Port` are both set. The `Host` and `Port` fields can be blank if the `ClusterId` field is set.
 */
public class RedshiftParameters private constructor(builder: Builder) {
    /**
     * Cluster ID. This field can be blank if the `Host` and `Port` are provided.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * Database.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * Host. This field can be blank if `ClusterId` is provided.
     */
    public val host: kotlin.String? = builder.host
    /**
     * An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster. This parameter can be used instead of [DataSourceCredentials](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html).
     */
    public val iamParameters: aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters? = builder.iamParameters
    /**
     * An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.
     *
     * This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
     */
    public val identityCenterConfiguration: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration? = builder.identityCenterConfiguration
    /**
     * Port. This field can be blank if the `ClusterId` is provided.
     */
    public val port: kotlin.Int = builder.port

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RedshiftParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftParameters(")
        append("clusterId=$clusterId,")
        append("database=$database,")
        append("host=$host,")
        append("iamParameters=$iamParameters,")
        append("identityCenterConfiguration=$identityCenterConfiguration,")
        append("port=$port")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterId?.hashCode() ?: 0
        result = 31 * result + (database.hashCode())
        result = 31 * result + (host?.hashCode() ?: 0)
        result = 31 * result + (iamParameters?.hashCode() ?: 0)
        result = 31 * result + (identityCenterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (port)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftParameters

        if (clusterId != other.clusterId) return false
        if (database != other.database) return false
        if (host != other.host) return false
        if (iamParameters != other.iamParameters) return false
        if (identityCenterConfiguration != other.identityCenterConfiguration) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RedshiftParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Cluster ID. This field can be blank if the `Host` and `Port` are provided.
         */
        public var clusterId: kotlin.String? = null
        /**
         * Database.
         */
        public var database: kotlin.String? = null
        /**
         * Host. This field can be blank if `ClusterId` is provided.
         */
        public var host: kotlin.String? = null
        /**
         * An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster. This parameter can be used instead of [DataSourceCredentials](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html).
         */
        public var iamParameters: aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters? = null
        /**
         * An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.
         *
         * This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
         */
        public var identityCenterConfiguration: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration? = null
        /**
         * Port. This field can be blank if the `ClusterId` is provided.
         */
        public var port: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RedshiftParameters) : this() {
            this.clusterId = x.clusterId
            this.database = x.database
            this.host = x.host
            this.iamParameters = x.iamParameters
            this.identityCenterConfiguration = x.identityCenterConfiguration
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RedshiftParameters = RedshiftParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters] inside the given [block]
         */
        public fun iamParameters(block: aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters.Builder.() -> kotlin.Unit) {
            this.iamParameters = aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration] inside the given [block]
         */
        public fun identityCenterConfiguration(block: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration.Builder.() -> kotlin.Unit) {
            this.identityCenterConfiguration = aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (database == null) database = ""
            return this
        }
    }
}
