// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that grants Amazon QuickSight access to your cluster and make a call to the `redshift:GetClusterCredentials` API. For more information on the `redshift:GetClusterCredentials` API, see `GetClusterCredentials`[](https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html).
 */
public class RedshiftIamParameters private constructor(builder: Builder) {
    /**
     * Automatically creates a database user. If your database doesn't have a `DatabaseUser`, set this parameter to `True`. If there is no `DatabaseUser`, Amazon QuickSight can't connect to your cluster. The `RoleArn` that you use for this operation must grant access to `redshift:CreateClusterUser` to successfully create the user.
     */
    public val autoCreateDatabaseUser: kotlin.Boolean = builder.autoCreateDatabaseUser
    /**
     * A list of groups whose permissions will be granted to Amazon QuickSight to access the cluster. These permissions are combined with the permissions granted to Amazon QuickSight by the `DatabaseUser`. If you choose to include this parameter, the `RoleArn` must grant access to `redshift:JoinGroup`.
     */
    public val databaseGroups: List<String>? = builder.databaseGroups
    /**
     * The user whose permissions and group memberships will be used by Amazon QuickSight to access the cluster. If this user already exists in your database, Amazon QuickSight is granted the same permissions that the user has. If the user doesn't exist, set the value of `AutoCreateDatabaseUser` to `True` to create a new user with PUBLIC permissions.
     */
    public val databaseUser: kotlin.String? = builder.databaseUser
    /**
     * Use the `RoleArn` structure to allow Amazon QuickSight to call `redshift:GetClusterCredentials` on your cluster. The calling principal must have `iam:PassRole` access to pass the role to Amazon QuickSight. The role's trust policy must allow the Amazon QuickSight service principal to assume the role.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftIamParameters(")
        append("autoCreateDatabaseUser=$autoCreateDatabaseUser,")
        append("databaseGroups=$databaseGroups,")
        append("databaseUser=$databaseUser,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoCreateDatabaseUser.hashCode()
        result = 31 * result + (databaseGroups?.hashCode() ?: 0)
        result = 31 * result + (databaseUser?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftIamParameters

        if (autoCreateDatabaseUser != other.autoCreateDatabaseUser) return false
        if (databaseGroups != other.databaseGroups) return false
        if (databaseUser != other.databaseUser) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Automatically creates a database user. If your database doesn't have a `DatabaseUser`, set this parameter to `True`. If there is no `DatabaseUser`, Amazon QuickSight can't connect to your cluster. The `RoleArn` that you use for this operation must grant access to `redshift:CreateClusterUser` to successfully create the user.
         */
        public var autoCreateDatabaseUser: kotlin.Boolean = false
        /**
         * A list of groups whose permissions will be granted to Amazon QuickSight to access the cluster. These permissions are combined with the permissions granted to Amazon QuickSight by the `DatabaseUser`. If you choose to include this parameter, the `RoleArn` must grant access to `redshift:JoinGroup`.
         */
        public var databaseGroups: List<String>? = null
        /**
         * The user whose permissions and group memberships will be used by Amazon QuickSight to access the cluster. If this user already exists in your database, Amazon QuickSight is granted the same permissions that the user has. If the user doesn't exist, set the value of `AutoCreateDatabaseUser` to `True` to create a new user with PUBLIC permissions.
         */
        public var databaseUser: kotlin.String? = null
        /**
         * Use the `RoleArn` structure to allow Amazon QuickSight to call `redshift:GetClusterCredentials` on your cluster. The calling principal must have `iam:PassRole` access to pass the role to Amazon QuickSight. The role's trust policy must allow the Amazon QuickSight service principal to assume the role.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters) : this() {
            this.autoCreateDatabaseUser = x.autoCreateDatabaseUser
            this.databaseGroups = x.databaseGroups
            this.databaseUser = x.databaseUser
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RedshiftIamParameters = RedshiftIamParameters(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
