// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A flexible visualization type that allows engineers to create new custom charts in Amazon QuickSight.
 */
public class PluginVisual private constructor(builder: Builder) {
    /**
     * The list of custom actions that are configured for a visual.
     */
    public val actions: List<VisualCustomAction>? = builder.actions
    /**
     * A description of the plugin field wells and their persisted properties.
     */
    public val chartConfiguration: aws.sdk.kotlin.services.quicksight.model.PluginVisualConfiguration? = builder.chartConfiguration
    /**
     * The Amazon Resource Name (ARN) that reflects the plugin and version.
     */
    public val pluginArn: kotlin.String = requireNotNull(builder.pluginArn) { "A non-null value must be provided for pluginArn" }
    /**
     * The subtitle label options for a visual.
     */
    public val subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = builder.subtitle
    /**
     * The title label options for a visual.
     */
    public val title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = builder.title
    /**
     * The alt text for the visual.
     */
    public val visualContentAltText: kotlin.String? = builder.visualContentAltText
    /**
     * The ID of the visual that you want to use.
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.PluginVisual = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PluginVisual(")
        append("actions=$actions,")
        append("chartConfiguration=$chartConfiguration,")
        append("pluginArn=$pluginArn,")
        append("subtitle=$subtitle,")
        append("title=$title,")
        append("visualContentAltText=$visualContentAltText,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (chartConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pluginArn.hashCode())
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (visualContentAltText?.hashCode() ?: 0)
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PluginVisual

        if (actions != other.actions) return false
        if (chartConfiguration != other.chartConfiguration) return false
        if (pluginArn != other.pluginArn) return false
        if (subtitle != other.subtitle) return false
        if (title != other.title) return false
        if (visualContentAltText != other.visualContentAltText) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.PluginVisual = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of custom actions that are configured for a visual.
         */
        public var actions: List<VisualCustomAction>? = null
        /**
         * A description of the plugin field wells and their persisted properties.
         */
        public var chartConfiguration: aws.sdk.kotlin.services.quicksight.model.PluginVisualConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) that reflects the plugin and version.
         */
        public var pluginArn: kotlin.String? = null
        /**
         * The subtitle label options for a visual.
         */
        public var subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = null
        /**
         * The title label options for a visual.
         */
        public var title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = null
        /**
         * The alt text for the visual.
         */
        public var visualContentAltText: kotlin.String? = null
        /**
         * The ID of the visual that you want to use.
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.PluginVisual) : this() {
            this.actions = x.actions
            this.chartConfiguration = x.chartConfiguration
            this.pluginArn = x.pluginArn
            this.subtitle = x.subtitle
            this.title = x.title
            this.visualContentAltText = x.visualContentAltText
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.PluginVisual = PluginVisual(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PluginVisualConfiguration] inside the given [block]
         */
        public fun chartConfiguration(block: aws.sdk.kotlin.services.quicksight.model.PluginVisualConfiguration.Builder.() -> kotlin.Unit) {
            this.chartConfiguration = aws.sdk.kotlin.services.quicksight.model.PluginVisualConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions] inside the given [block]
         */
        public fun subtitle(block: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.subtitle = aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions] inside the given [block]
         */
        public fun title(block: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.title = aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (pluginArn == null) pluginArn = ""
            if (visualId == null) visualId = ""
            return this
        }
    }
}
