// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A pivot table.
 *
 * For more information, see [Using pivot tables](https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html) in the *Amazon QuickSight User Guide*.
 */
public class PivotTableVisual private constructor(builder: Builder) {
    /**
     * The list of custom actions that are configured for a visual.
     */
    public val actions: List<VisualCustomAction>? = builder.actions
    /**
     * The configuration settings of the visual.
     */
    public val chartConfiguration: aws.sdk.kotlin.services.quicksight.model.PivotTableConfiguration? = builder.chartConfiguration
    /**
     * The conditional formatting for a `PivotTableVisual`.
     */
    public val conditionalFormatting: aws.sdk.kotlin.services.quicksight.model.PivotTableConditionalFormatting? = builder.conditionalFormatting
    /**
     * The subtitle that is displayed on the visual.
     */
    public val subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = builder.subtitle
    /**
     * The title that is displayed on the visual.
     */
    public val title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = builder.title
    /**
     * The alt text for the visual.
     */
    public val visualContentAltText: kotlin.String? = builder.visualContentAltText
    /**
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.PivotTableVisual = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PivotTableVisual(")
        append("actions=$actions,")
        append("chartConfiguration=$chartConfiguration,")
        append("conditionalFormatting=$conditionalFormatting,")
        append("subtitle=$subtitle,")
        append("title=$title,")
        append("visualContentAltText=$visualContentAltText,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (chartConfiguration?.hashCode() ?: 0)
        result = 31 * result + (conditionalFormatting?.hashCode() ?: 0)
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (visualContentAltText?.hashCode() ?: 0)
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PivotTableVisual

        if (actions != other.actions) return false
        if (chartConfiguration != other.chartConfiguration) return false
        if (conditionalFormatting != other.conditionalFormatting) return false
        if (subtitle != other.subtitle) return false
        if (title != other.title) return false
        if (visualContentAltText != other.visualContentAltText) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.PivotTableVisual = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of custom actions that are configured for a visual.
         */
        public var actions: List<VisualCustomAction>? = null
        /**
         * The configuration settings of the visual.
         */
        public var chartConfiguration: aws.sdk.kotlin.services.quicksight.model.PivotTableConfiguration? = null
        /**
         * The conditional formatting for a `PivotTableVisual`.
         */
        public var conditionalFormatting: aws.sdk.kotlin.services.quicksight.model.PivotTableConditionalFormatting? = null
        /**
         * The subtitle that is displayed on the visual.
         */
        public var subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = null
        /**
         * The title that is displayed on the visual.
         */
        public var title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = null
        /**
         * The alt text for the visual.
         */
        public var visualContentAltText: kotlin.String? = null
        /**
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.PivotTableVisual) : this() {
            this.actions = x.actions
            this.chartConfiguration = x.chartConfiguration
            this.conditionalFormatting = x.conditionalFormatting
            this.subtitle = x.subtitle
            this.title = x.title
            this.visualContentAltText = x.visualContentAltText
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.PivotTableVisual = PivotTableVisual(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PivotTableConfiguration] inside the given [block]
         */
        public fun chartConfiguration(block: aws.sdk.kotlin.services.quicksight.model.PivotTableConfiguration.Builder.() -> kotlin.Unit) {
            this.chartConfiguration = aws.sdk.kotlin.services.quicksight.model.PivotTableConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PivotTableConditionalFormatting] inside the given [block]
         */
        public fun conditionalFormatting(block: aws.sdk.kotlin.services.quicksight.model.PivotTableConditionalFormatting.Builder.() -> kotlin.Unit) {
            this.conditionalFormatting = aws.sdk.kotlin.services.quicksight.model.PivotTableConditionalFormatting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions] inside the given [block]
         */
        public fun subtitle(block: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.subtitle = aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions] inside the given [block]
         */
        public fun title(block: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.title = aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (visualId == null) visualId = ""
            return this
        }
    }
}
