// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The table options for a pivot table visual.
 */
public class PivotTableOptions private constructor(builder: Builder) {
    /**
     * The table cell style of cells.
     */
    public val cellStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = builder.cellStyle
    /**
     * The visibility setting of a pivot table's collapsed row dimension fields. If the value of this structure is `HIDDEN`, all collapsed columns in a pivot table are automatically hidden. The default value is `VISIBLE`.
     */
    public val collapsedRowDimensionsVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = builder.collapsedRowDimensionsVisibility
    /**
     * The table cell style of the column header.
     */
    public val columnHeaderStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = builder.columnHeaderStyle
    /**
     * The visibility of the column names.
     */
    public val columnNamesVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = builder.columnNamesVisibility
    /**
     * The default cell width of the pivot table.
     */
    public val defaultCellWidth: kotlin.String? = builder.defaultCellWidth
    /**
     * The metric placement (row, column) options.
     */
    public val metricPlacement: aws.sdk.kotlin.services.quicksight.model.PivotTableMetricPlacement? = builder.metricPlacement
    /**
     * The row alternate color options (widget status, row alternate colors).
     */
    public val rowAlternateColorOptions: aws.sdk.kotlin.services.quicksight.model.RowAlternateColorOptions? = builder.rowAlternateColorOptions
    /**
     * The table cell style of row field names.
     */
    public val rowFieldNamesStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = builder.rowFieldNamesStyle
    /**
     * The table cell style of the row headers.
     */
    public val rowHeaderStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = builder.rowHeaderStyle
    /**
     * The options for the label that is located above the row headers. This option is only applicable when `RowsLayout` is set to `HIERARCHY`.
     */
    public val rowsLabelOptions: aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLabelOptions? = builder.rowsLabelOptions
    /**
     * The layout for the row dimension headers of a pivot table. Choose one of the following options.
     * + `TABULAR`: (Default) Each row field is displayed in a separate column.
     * + `HIERARCHY`: All row fields are displayed in a single column. Indentation is used to differentiate row headers of different fields.
     */
    public val rowsLayout: aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLayout? = builder.rowsLayout
    /**
     * The visibility of the single metric options.
     */
    public val singleMetricVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = builder.singleMetricVisibility
    /**
     * Determines the visibility of the pivot table.
     */
    public val toggleButtonsVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = builder.toggleButtonsVisibility

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.PivotTableOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PivotTableOptions(")
        append("cellStyle=$cellStyle,")
        append("collapsedRowDimensionsVisibility=$collapsedRowDimensionsVisibility,")
        append("columnHeaderStyle=$columnHeaderStyle,")
        append("columnNamesVisibility=$columnNamesVisibility,")
        append("defaultCellWidth=$defaultCellWidth,")
        append("metricPlacement=$metricPlacement,")
        append("rowAlternateColorOptions=$rowAlternateColorOptions,")
        append("rowFieldNamesStyle=$rowFieldNamesStyle,")
        append("rowHeaderStyle=$rowHeaderStyle,")
        append("rowsLabelOptions=$rowsLabelOptions,")
        append("rowsLayout=$rowsLayout,")
        append("singleMetricVisibility=$singleMetricVisibility,")
        append("toggleButtonsVisibility=$toggleButtonsVisibility")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellStyle?.hashCode() ?: 0
        result = 31 * result + (collapsedRowDimensionsVisibility?.hashCode() ?: 0)
        result = 31 * result + (columnHeaderStyle?.hashCode() ?: 0)
        result = 31 * result + (columnNamesVisibility?.hashCode() ?: 0)
        result = 31 * result + (defaultCellWidth?.hashCode() ?: 0)
        result = 31 * result + (metricPlacement?.hashCode() ?: 0)
        result = 31 * result + (rowAlternateColorOptions?.hashCode() ?: 0)
        result = 31 * result + (rowFieldNamesStyle?.hashCode() ?: 0)
        result = 31 * result + (rowHeaderStyle?.hashCode() ?: 0)
        result = 31 * result + (rowsLabelOptions?.hashCode() ?: 0)
        result = 31 * result + (rowsLayout?.hashCode() ?: 0)
        result = 31 * result + (singleMetricVisibility?.hashCode() ?: 0)
        result = 31 * result + (toggleButtonsVisibility?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PivotTableOptions

        if (cellStyle != other.cellStyle) return false
        if (collapsedRowDimensionsVisibility != other.collapsedRowDimensionsVisibility) return false
        if (columnHeaderStyle != other.columnHeaderStyle) return false
        if (columnNamesVisibility != other.columnNamesVisibility) return false
        if (defaultCellWidth != other.defaultCellWidth) return false
        if (metricPlacement != other.metricPlacement) return false
        if (rowAlternateColorOptions != other.rowAlternateColorOptions) return false
        if (rowFieldNamesStyle != other.rowFieldNamesStyle) return false
        if (rowHeaderStyle != other.rowHeaderStyle) return false
        if (rowsLabelOptions != other.rowsLabelOptions) return false
        if (rowsLayout != other.rowsLayout) return false
        if (singleMetricVisibility != other.singleMetricVisibility) return false
        if (toggleButtonsVisibility != other.toggleButtonsVisibility) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.PivotTableOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The table cell style of cells.
         */
        public var cellStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = null
        /**
         * The visibility setting of a pivot table's collapsed row dimension fields. If the value of this structure is `HIDDEN`, all collapsed columns in a pivot table are automatically hidden. The default value is `VISIBLE`.
         */
        public var collapsedRowDimensionsVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = null
        /**
         * The table cell style of the column header.
         */
        public var columnHeaderStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = null
        /**
         * The visibility of the column names.
         */
        public var columnNamesVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = null
        /**
         * The default cell width of the pivot table.
         */
        public var defaultCellWidth: kotlin.String? = null
        /**
         * The metric placement (row, column) options.
         */
        public var metricPlacement: aws.sdk.kotlin.services.quicksight.model.PivotTableMetricPlacement? = null
        /**
         * The row alternate color options (widget status, row alternate colors).
         */
        public var rowAlternateColorOptions: aws.sdk.kotlin.services.quicksight.model.RowAlternateColorOptions? = null
        /**
         * The table cell style of row field names.
         */
        public var rowFieldNamesStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = null
        /**
         * The table cell style of the row headers.
         */
        public var rowHeaderStyle: aws.sdk.kotlin.services.quicksight.model.TableCellStyle? = null
        /**
         * The options for the label that is located above the row headers. This option is only applicable when `RowsLayout` is set to `HIERARCHY`.
         */
        public var rowsLabelOptions: aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLabelOptions? = null
        /**
         * The layout for the row dimension headers of a pivot table. Choose one of the following options.
         * + `TABULAR`: (Default) Each row field is displayed in a separate column.
         * + `HIERARCHY`: All row fields are displayed in a single column. Indentation is used to differentiate row headers of different fields.
         */
        public var rowsLayout: aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLayout? = null
        /**
         * The visibility of the single metric options.
         */
        public var singleMetricVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = null
        /**
         * Determines the visibility of the pivot table.
         */
        public var toggleButtonsVisibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.PivotTableOptions) : this() {
            this.cellStyle = x.cellStyle
            this.collapsedRowDimensionsVisibility = x.collapsedRowDimensionsVisibility
            this.columnHeaderStyle = x.columnHeaderStyle
            this.columnNamesVisibility = x.columnNamesVisibility
            this.defaultCellWidth = x.defaultCellWidth
            this.metricPlacement = x.metricPlacement
            this.rowAlternateColorOptions = x.rowAlternateColorOptions
            this.rowFieldNamesStyle = x.rowFieldNamesStyle
            this.rowHeaderStyle = x.rowHeaderStyle
            this.rowsLabelOptions = x.rowsLabelOptions
            this.rowsLayout = x.rowsLayout
            this.singleMetricVisibility = x.singleMetricVisibility
            this.toggleButtonsVisibility = x.toggleButtonsVisibility
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.PivotTableOptions = PivotTableOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TableCellStyle] inside the given [block]
         */
        public fun cellStyle(block: aws.sdk.kotlin.services.quicksight.model.TableCellStyle.Builder.() -> kotlin.Unit) {
            this.cellStyle = aws.sdk.kotlin.services.quicksight.model.TableCellStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TableCellStyle] inside the given [block]
         */
        public fun columnHeaderStyle(block: aws.sdk.kotlin.services.quicksight.model.TableCellStyle.Builder.() -> kotlin.Unit) {
            this.columnHeaderStyle = aws.sdk.kotlin.services.quicksight.model.TableCellStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowAlternateColorOptions] inside the given [block]
         */
        public fun rowAlternateColorOptions(block: aws.sdk.kotlin.services.quicksight.model.RowAlternateColorOptions.Builder.() -> kotlin.Unit) {
            this.rowAlternateColorOptions = aws.sdk.kotlin.services.quicksight.model.RowAlternateColorOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TableCellStyle] inside the given [block]
         */
        public fun rowFieldNamesStyle(block: aws.sdk.kotlin.services.quicksight.model.TableCellStyle.Builder.() -> kotlin.Unit) {
            this.rowFieldNamesStyle = aws.sdk.kotlin.services.quicksight.model.TableCellStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TableCellStyle] inside the given [block]
         */
        public fun rowHeaderStyle(block: aws.sdk.kotlin.services.quicksight.model.TableCellStyle.Builder.() -> kotlin.Unit) {
            this.rowHeaderStyle = aws.sdk.kotlin.services.quicksight.model.TableCellStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLabelOptions] inside the given [block]
         */
        public fun rowsLabelOptions(block: aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLabelOptions.Builder.() -> kotlin.Unit) {
            this.rowsLabelOptions = aws.sdk.kotlin.services.quicksight.model.PivotTableRowsLabelOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
