// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that contains information needed to create a data source connection that uses OAuth client credentials. This option is available for data source connections that are made with Snowflake and Starburst.
 */
public class OAuthParameters private constructor(builder: Builder) {
    /**
     * The resource uri of the identity provider.
     */
    public val identityProviderResourceUri: kotlin.String? = builder.identityProviderResourceUri
    /**
     * VPC connection properties.
     */
    public val identityProviderVpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = builder.identityProviderVpcConnectionProperties
    /**
     * The OAuth scope.
     */
    public val oAuthScope: kotlin.String? = builder.oAuthScope
    /**
     * The token endpoint URL of the identity provider.
     */
    public val tokenProviderUrl: kotlin.String = requireNotNull(builder.tokenProviderUrl) { "A non-null value must be provided for tokenProviderUrl" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.OAuthParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OAuthParameters(")
        append("identityProviderResourceUri=$identityProviderResourceUri,")
        append("identityProviderVpcConnectionProperties=$identityProviderVpcConnectionProperties,")
        append("oAuthScope=$oAuthScope,")
        append("tokenProviderUrl=$tokenProviderUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityProviderResourceUri?.hashCode() ?: 0
        result = 31 * result + (identityProviderVpcConnectionProperties?.hashCode() ?: 0)
        result = 31 * result + (oAuthScope?.hashCode() ?: 0)
        result = 31 * result + (tokenProviderUrl.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OAuthParameters

        if (identityProviderResourceUri != other.identityProviderResourceUri) return false
        if (identityProviderVpcConnectionProperties != other.identityProviderVpcConnectionProperties) return false
        if (oAuthScope != other.oAuthScope) return false
        if (tokenProviderUrl != other.tokenProviderUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.OAuthParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The resource uri of the identity provider.
         */
        public var identityProviderResourceUri: kotlin.String? = null
        /**
         * VPC connection properties.
         */
        public var identityProviderVpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = null
        /**
         * The OAuth scope.
         */
        public var oAuthScope: kotlin.String? = null
        /**
         * The token endpoint URL of the identity provider.
         */
        public var tokenProviderUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.OAuthParameters) : this() {
            this.identityProviderResourceUri = x.identityProviderResourceUri
            this.identityProviderVpcConnectionProperties = x.identityProviderVpcConnectionProperties
            this.oAuthScope = x.oAuthScope
            this.tokenProviderUrl = x.tokenProviderUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.OAuthParameters = OAuthParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties] inside the given [block]
         */
        public fun identityProviderVpcConnectionProperties(block: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.Builder.() -> kotlin.Unit) {
            this.identityProviderVpcConnectionProperties = aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (tokenProviderUrl == null) tokenProviderUrl = ""
            return this
        }
    }
}
