// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `NumericRangeFilter` filters values that are within the value range.
 */
public class NumericRangeFilter private constructor(builder: Builder) {
    /**
     * The aggregation function of the filter.
     */
    public val aggregationFunction: aws.sdk.kotlin.services.quicksight.model.AggregationFunction? = builder.aggregationFunction
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * Determines whether the maximum value in the filter value range should be included in the filtered results.
     */
    public val includeMaximum: kotlin.Boolean? = builder.includeMaximum
    /**
     * Determines whether the minimum value in the filter value range should be included in the filtered results.
     */
    public val includeMinimum: kotlin.Boolean? = builder.includeMinimum
    /**
     * This option determines how null values should be treated when filtering data.
     * + `ALL_VALUES`: Include null values in filtered results.
     * + `NULLS_ONLY`: Only include null values in filtered results.
     * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
     */
    public val nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption = requireNotNull(builder.nullOption) { "A non-null value must be provided for nullOption" }
    /**
     * The maximum value for the filter value range.
     */
    public val rangeMaximum: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue? = builder.rangeMaximum
    /**
     * The minimum value for the filter value range.
     */
    public val rangeMinimum: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue? = builder.rangeMinimum
    /**
     * Select all of the values. Null is not the assigned value of select all.
     * + `FILTER_ALL_VALUES`
     */
    public val selectAllOptions: aws.sdk.kotlin.services.quicksight.model.NumericFilterSelectAllOptions? = builder.selectAllOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NumericRangeFilter(")
        append("aggregationFunction=$aggregationFunction,")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("filterId=$filterId,")
        append("includeMaximum=$includeMaximum,")
        append("includeMinimum=$includeMinimum,")
        append("nullOption=$nullOption,")
        append("rangeMaximum=$rangeMaximum,")
        append("rangeMinimum=$rangeMinimum,")
        append("selectAllOptions=$selectAllOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationFunction?.hashCode() ?: 0
        result = 31 * result + (column?.hashCode() ?: 0)
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (includeMaximum?.hashCode() ?: 0)
        result = 31 * result + (includeMinimum?.hashCode() ?: 0)
        result = 31 * result + (nullOption.hashCode())
        result = 31 * result + (rangeMaximum?.hashCode() ?: 0)
        result = 31 * result + (rangeMinimum?.hashCode() ?: 0)
        result = 31 * result + (selectAllOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NumericRangeFilter

        if (aggregationFunction != other.aggregationFunction) return false
        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (filterId != other.filterId) return false
        if (includeMaximum != other.includeMaximum) return false
        if (includeMinimum != other.includeMinimum) return false
        if (nullOption != other.nullOption) return false
        if (rangeMaximum != other.rangeMaximum) return false
        if (rangeMinimum != other.rangeMinimum) return false
        if (selectAllOptions != other.selectAllOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The aggregation function of the filter.
         */
        public var aggregationFunction: aws.sdk.kotlin.services.quicksight.model.AggregationFunction? = null
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         */
        public var includeMaximum: kotlin.Boolean? = null
        /**
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         */
        public var includeMinimum: kotlin.Boolean? = null
        /**
         * This option determines how null values should be treated when filtering data.
         * + `ALL_VALUES`: Include null values in filtered results.
         * + `NULLS_ONLY`: Only include null values in filtered results.
         * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
         */
        public var nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption? = null
        /**
         * The maximum value for the filter value range.
         */
        public var rangeMaximum: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue? = null
        /**
         * The minimum value for the filter value range.
         */
        public var rangeMinimum: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue? = null
        /**
         * Select all of the values. Null is not the assigned value of select all.
         * + `FILTER_ALL_VALUES`
         */
        public var selectAllOptions: aws.sdk.kotlin.services.quicksight.model.NumericFilterSelectAllOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter) : this() {
            this.aggregationFunction = x.aggregationFunction
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.filterId = x.filterId
            this.includeMaximum = x.includeMaximum
            this.includeMinimum = x.includeMinimum
            this.nullOption = x.nullOption
            this.rangeMaximum = x.rangeMaximum
            this.rangeMinimum = x.rangeMinimum
            this.selectAllOptions = x.selectAllOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter = NumericRangeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AggregationFunction] inside the given [block]
         */
        public fun aggregationFunction(block: aws.sdk.kotlin.services.quicksight.model.AggregationFunction.Builder.() -> kotlin.Unit) {
            this.aggregationFunction = aws.sdk.kotlin.services.quicksight.model.AggregationFunction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue] inside the given [block]
         */
        public fun rangeMaximum(block: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue.Builder.() -> kotlin.Unit) {
            this.rangeMaximum = aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue] inside the given [block]
         */
        public fun rangeMinimum(block: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue.Builder.() -> kotlin.Unit) {
            this.rangeMinimum = aws.sdk.kotlin.services.quicksight.model.NumericRangeFilterValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            if (nullOption == null) nullOption = FilterNullOption.SdkUnknown("no value provided")
            return this
        }
    }
}
