// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `NumericEqualityFilter` filters values that are equal to the specified value.
 */
public class NumericEqualityFilter private constructor(builder: Builder) {
    /**
     * The aggregation function of the filter.
     */
    public val aggregationFunction: aws.sdk.kotlin.services.quicksight.model.AggregationFunction? = builder.aggregationFunction
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * The match operator that is used to determine if a filter should be applied.
     */
    public val matchOperator: aws.sdk.kotlin.services.quicksight.model.NumericEqualityMatchOperator = requireNotNull(builder.matchOperator) { "A non-null value must be provided for matchOperator" }
    /**
     * This option determines how null values should be treated when filtering data.
     * + `ALL_VALUES`: Include null values in filtered results.
     * + `NULLS_ONLY`: Only include null values in filtered results.
     * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
     */
    public val nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption = requireNotNull(builder.nullOption) { "A non-null value must be provided for nullOption" }
    /**
     * The parameter whose value should be used for the filter value.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * Select all of the values. Null is not the assigned value of select all.
     * + `FILTER_ALL_VALUES`
     */
    public val selectAllOptions: aws.sdk.kotlin.services.quicksight.model.NumericFilterSelectAllOptions? = builder.selectAllOptions
    /**
     * The input value.
     */
    public val value: kotlin.Double? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NumericEqualityFilter(")
        append("aggregationFunction=$aggregationFunction,")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("filterId=$filterId,")
        append("matchOperator=$matchOperator,")
        append("nullOption=$nullOption,")
        append("parameterName=$parameterName,")
        append("selectAllOptions=$selectAllOptions,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationFunction?.hashCode() ?: 0
        result = 31 * result + (column?.hashCode() ?: 0)
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (matchOperator.hashCode())
        result = 31 * result + (nullOption.hashCode())
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (selectAllOptions?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NumericEqualityFilter

        if (aggregationFunction != other.aggregationFunction) return false
        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (filterId != other.filterId) return false
        if (matchOperator != other.matchOperator) return false
        if (nullOption != other.nullOption) return false
        if (parameterName != other.parameterName) return false
        if (selectAllOptions != other.selectAllOptions) return false
        if (!(value?.equals(other.value) ?: (other.value == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The aggregation function of the filter.
         */
        public var aggregationFunction: aws.sdk.kotlin.services.quicksight.model.AggregationFunction? = null
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * The match operator that is used to determine if a filter should be applied.
         */
        public var matchOperator: aws.sdk.kotlin.services.quicksight.model.NumericEqualityMatchOperator? = null
        /**
         * This option determines how null values should be treated when filtering data.
         * + `ALL_VALUES`: Include null values in filtered results.
         * + `NULLS_ONLY`: Only include null values in filtered results.
         * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
         */
        public var nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption? = null
        /**
         * The parameter whose value should be used for the filter value.
         */
        public var parameterName: kotlin.String? = null
        /**
         * Select all of the values. Null is not the assigned value of select all.
         * + `FILTER_ALL_VALUES`
         */
        public var selectAllOptions: aws.sdk.kotlin.services.quicksight.model.NumericFilterSelectAllOptions? = null
        /**
         * The input value.
         */
        public var value: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter) : this() {
            this.aggregationFunction = x.aggregationFunction
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.filterId = x.filterId
            this.matchOperator = x.matchOperator
            this.nullOption = x.nullOption
            this.parameterName = x.parameterName
            this.selectAllOptions = x.selectAllOptions
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter = NumericEqualityFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AggregationFunction] inside the given [block]
         */
        public fun aggregationFunction(block: aws.sdk.kotlin.services.quicksight.model.AggregationFunction.Builder.() -> kotlin.Unit) {
            this.aggregationFunction = aws.sdk.kotlin.services.quicksight.model.AggregationFunction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            if (matchOperator == null) matchOperator = NumericEqualityMatchOperator.SdkUnknown("no value provided")
            if (nullOption == null) nullOption = FilterNullOption.SdkUnknown("no value provided")
            return this
        }
    }
}
