// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
 */
public class NestedFilter private constructor(builder: Builder) {
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * A boolean condition to include or exclude the subset that is defined by the values of the nested inner filter.
     */
    public val includeInnerSet: kotlin.Boolean = builder.includeInnerSet
    /**
     * The `InnerFilter` defines the subset of data to be used with the `NestedFilter`.
     */
    public val innerFilter: aws.sdk.kotlin.services.quicksight.model.InnerFilter? = builder.innerFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.NestedFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NestedFilter(")
        append("column=$column,")
        append("filterId=$filterId,")
        append("includeInnerSet=$includeInnerSet,")
        append("innerFilter=$innerFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (includeInnerSet.hashCode())
        result = 31 * result + (innerFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NestedFilter

        if (column != other.column) return false
        if (filterId != other.filterId) return false
        if (includeInnerSet != other.includeInnerSet) return false
        if (innerFilter != other.innerFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.NestedFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * A boolean condition to include or exclude the subset that is defined by the values of the nested inner filter.
         */
        public var includeInnerSet: kotlin.Boolean = false
        /**
         * The `InnerFilter` defines the subset of data to be used with the `NestedFilter`.
         */
        public var innerFilter: aws.sdk.kotlin.services.quicksight.model.InnerFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.NestedFilter) : this() {
            this.column = x.column
            this.filterId = x.filterId
            this.includeInnerSet = x.includeInnerSet
            this.innerFilter = x.innerFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.NestedFilter = NestedFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.InnerFilter] inside the given [block]
         */
        public fun innerFilter(block: aws.sdk.kotlin.services.quicksight.model.InnerFilter.Builder.() -> kotlin.Unit) {
            this.innerFilter = aws.sdk.kotlin.services.quicksight.model.InnerFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            return this
        }
    }
}
