// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListThemesRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that contains the themes that you're listing.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The maximum number of results to be returned per request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results, or null if there are no more results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of themes that you want to list. Valid options include the following:
     * + `ALL (default)`- Display all existing themes.
     * + `CUSTOM` - Display only the themes created by people using Amazon QuickSight.
     * + `QUICKSIGHT` - Display only the starting themes defined by Amazon QuickSight.
     */
    public val type: aws.sdk.kotlin.services.quicksight.model.ThemeType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ListThemesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListThemesRequest(")
        append("awsAccountId=$awsAccountId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListThemesRequest

        if (awsAccountId != other.awsAccountId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ListThemesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that contains the themes that you're listing.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The maximum number of results to be returned per request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results, or null if there are no more results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of themes that you want to list. Valid options include the following:
         * + `ALL (default)`- Display all existing themes.
         * + `CUSTOM` - Display only the themes created by people using Amazon QuickSight.
         * + `QUICKSIGHT` - Display only the starting themes defined by Amazon QuickSight.
         */
        public var type: aws.sdk.kotlin.services.quicksight.model.ThemeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ListThemesRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ListThemesRequest = ListThemesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
