// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListNamespacesResponse private constructor(builder: Builder) {
    /**
     * The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
     */
    public val namespaces: List<NamespaceInfoV2>? = builder.namespaces
    /**
     * A unique pagination token that can be used in a subsequent request. Receiving `NextToken` in your response inticates that there is more data that can be returned. To receive the data, make another `ListNamespaces` API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a `ListNamespaces` API call with an expired token, you will receive a `HTTP 400 InvalidNextTokenException` error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services request ID for this operation.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The HTTP status of the request.
     */
    public val status: kotlin.Int = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListNamespacesResponse(")
        append("namespaces=$namespaces,")
        append("nextToken=$nextToken,")
        append("requestId=$requestId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespaces?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (status)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListNamespacesResponse

        if (namespaces != other.namespaces) return false
        if (nextToken != other.nextToken) return false
        if (requestId != other.requestId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
         */
        public var namespaces: List<NamespaceInfoV2>? = null
        /**
         * A unique pagination token that can be used in a subsequent request. Receiving `NextToken` in your response inticates that there is more data that can be returned. To receive the data, make another `ListNamespaces` API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a `ListNamespaces` API call with an expired token, you will receive a `HTTP 400 InvalidNextTokenException` error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services request ID for this operation.
         */
        public var requestId: kotlin.String? = null
        /**
         * The HTTP status of the request.
         */
        public var status: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse) : this() {
            this.namespaces = x.namespaces
            this.nextToken = x.nextToken
            this.requestId = x.requestId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse = ListNamespacesResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
