// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that determines what the type of layout will be used on a sheet.
 *
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 */
public class LayoutConfiguration private constructor(builder: Builder) {
    /**
     * A free-form is optimized for a fixed width and has more control over the exact placement of layout elements.
     */
    public val freeFormLayout: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutConfiguration? = builder.freeFormLayout
    /**
     * A type of layout that can be used on a sheet. In a grid layout, visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size. A grid layout can be configured to behave in one of two ways when the viewport is resized: `FIXED` or `RESPONSIVE`.
     */
    public val gridLayout: aws.sdk.kotlin.services.quicksight.model.GridLayoutConfiguration? = builder.gridLayout
    /**
     * A section based layout organizes visuals into multiple sections and has customized header, footer and page break.
     */
    public val sectionBasedLayout: aws.sdk.kotlin.services.quicksight.model.SectionBasedLayoutConfiguration? = builder.sectionBasedLayout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.LayoutConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LayoutConfiguration(")
        append("freeFormLayout=$freeFormLayout,")
        append("gridLayout=$gridLayout,")
        append("sectionBasedLayout=$sectionBasedLayout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = freeFormLayout?.hashCode() ?: 0
        result = 31 * result + (gridLayout?.hashCode() ?: 0)
        result = 31 * result + (sectionBasedLayout?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LayoutConfiguration

        if (freeFormLayout != other.freeFormLayout) return false
        if (gridLayout != other.gridLayout) return false
        if (sectionBasedLayout != other.sectionBasedLayout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.LayoutConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A free-form is optimized for a fixed width and has more control over the exact placement of layout elements.
         */
        public var freeFormLayout: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutConfiguration? = null
        /**
         * A type of layout that can be used on a sheet. In a grid layout, visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size. A grid layout can be configured to behave in one of two ways when the viewport is resized: `FIXED` or `RESPONSIVE`.
         */
        public var gridLayout: aws.sdk.kotlin.services.quicksight.model.GridLayoutConfiguration? = null
        /**
         * A section based layout organizes visuals into multiple sections and has customized header, footer and page break.
         */
        public var sectionBasedLayout: aws.sdk.kotlin.services.quicksight.model.SectionBasedLayoutConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.LayoutConfiguration) : this() {
            this.freeFormLayout = x.freeFormLayout
            this.gridLayout = x.gridLayout
            this.sectionBasedLayout = x.sectionBasedLayout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.LayoutConfiguration = LayoutConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutConfiguration] inside the given [block]
         */
        public fun freeFormLayout(block: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutConfiguration.Builder.() -> kotlin.Unit) {
            this.freeFormLayout = aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.GridLayoutConfiguration] inside the given [block]
         */
        public fun gridLayout(block: aws.sdk.kotlin.services.quicksight.model.GridLayoutConfiguration.Builder.() -> kotlin.Unit) {
            this.gridLayout = aws.sdk.kotlin.services.quicksight.model.GridLayoutConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SectionBasedLayoutConfiguration] inside the given [block]
         */
        public fun sectionBasedLayout(block: aws.sdk.kotlin.services.quicksight.model.SectionBasedLayoutConfiguration.Builder.() -> kotlin.Unit) {
            this.sectionBasedLayout = aws.sdk.kotlin.services.quicksight.model.SectionBasedLayoutConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
