// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An insight visual.
 *
 * For more information, see [Working with insights](https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html) in the *Amazon QuickSight User Guide*.
 */
public class InsightVisual private constructor(builder: Builder) {
    /**
     * The list of custom actions that are configured for a visual.
     */
    public val actions: List<VisualCustomAction>? = builder.actions
    /**
     * The dataset that is used in the insight visual.
     */
    public val dataSetIdentifier: kotlin.String = requireNotNull(builder.dataSetIdentifier) { "A non-null value must be provided for dataSetIdentifier" }
    /**
     * The configuration of an insight visual.
     */
    public val insightConfiguration: aws.sdk.kotlin.services.quicksight.model.InsightConfiguration? = builder.insightConfiguration
    /**
     * The subtitle that is displayed on the visual.
     */
    public val subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = builder.subtitle
    /**
     * The title that is displayed on the visual.
     */
    public val title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = builder.title
    /**
     * The alt text for the visual.
     */
    public val visualContentAltText: kotlin.String? = builder.visualContentAltText
    /**
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.InsightVisual = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightVisual(")
        append("actions=$actions,")
        append("dataSetIdentifier=$dataSetIdentifier,")
        append("insightConfiguration=$insightConfiguration,")
        append("subtitle=$subtitle,")
        append("title=$title,")
        append("visualContentAltText=$visualContentAltText,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (dataSetIdentifier.hashCode())
        result = 31 * result + (insightConfiguration?.hashCode() ?: 0)
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (visualContentAltText?.hashCode() ?: 0)
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightVisual

        if (actions != other.actions) return false
        if (dataSetIdentifier != other.dataSetIdentifier) return false
        if (insightConfiguration != other.insightConfiguration) return false
        if (subtitle != other.subtitle) return false
        if (title != other.title) return false
        if (visualContentAltText != other.visualContentAltText) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.InsightVisual = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of custom actions that are configured for a visual.
         */
        public var actions: List<VisualCustomAction>? = null
        /**
         * The dataset that is used in the insight visual.
         */
        public var dataSetIdentifier: kotlin.String? = null
        /**
         * The configuration of an insight visual.
         */
        public var insightConfiguration: aws.sdk.kotlin.services.quicksight.model.InsightConfiguration? = null
        /**
         * The subtitle that is displayed on the visual.
         */
        public var subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = null
        /**
         * The title that is displayed on the visual.
         */
        public var title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = null
        /**
         * The alt text for the visual.
         */
        public var visualContentAltText: kotlin.String? = null
        /**
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.InsightVisual) : this() {
            this.actions = x.actions
            this.dataSetIdentifier = x.dataSetIdentifier
            this.insightConfiguration = x.insightConfiguration
            this.subtitle = x.subtitle
            this.title = x.title
            this.visualContentAltText = x.visualContentAltText
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.InsightVisual = InsightVisual(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.InsightConfiguration] inside the given [block]
         */
        public fun insightConfiguration(block: aws.sdk.kotlin.services.quicksight.model.InsightConfiguration.Builder.() -> kotlin.Unit) {
            this.insightConfiguration = aws.sdk.kotlin.services.quicksight.model.InsightConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions] inside the given [block]
         */
        public fun subtitle(block: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.subtitle = aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions] inside the given [block]
         */
        public fun title(block: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.title = aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSetIdentifier == null) dataSetIdentifier = ""
            if (visualId == null) visualId = ""
            return this
        }
    }
}
