// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The options that determine the sizing of the canvas used in a grid layout.
 */
public class GridLayoutScreenCanvasSizeOptions private constructor(builder: Builder) {
    /**
     * The width that the view port will be optimized for when the layout renders.
     */
    public val optimizedViewPortWidth: kotlin.String? = builder.optimizedViewPortWidth
    /**
     * This value determines the layout behavior when the viewport is resized.
     * + `FIXED`: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this option is called `Classic`.
     * + `RESPONSIVE`: The width of the canvas will be responsive and optimized to the view port. In the Amazon QuickSight console, this option is called `Tiled`.
     */
    public val resizeOption: aws.sdk.kotlin.services.quicksight.model.ResizeOption = requireNotNull(builder.resizeOption) { "A non-null value must be provided for resizeOption" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.GridLayoutScreenCanvasSizeOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GridLayoutScreenCanvasSizeOptions(")
        append("optimizedViewPortWidth=$optimizedViewPortWidth,")
        append("resizeOption=$resizeOption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = optimizedViewPortWidth?.hashCode() ?: 0
        result = 31 * result + (resizeOption.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GridLayoutScreenCanvasSizeOptions

        if (optimizedViewPortWidth != other.optimizedViewPortWidth) return false
        if (resizeOption != other.resizeOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.GridLayoutScreenCanvasSizeOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The width that the view port will be optimized for when the layout renders.
         */
        public var optimizedViewPortWidth: kotlin.String? = null
        /**
         * This value determines the layout behavior when the viewport is resized.
         * + `FIXED`: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this option is called `Classic`.
         * + `RESPONSIVE`: The width of the canvas will be responsive and optimized to the view port. In the Amazon QuickSight console, this option is called `Tiled`.
         */
        public var resizeOption: aws.sdk.kotlin.services.quicksight.model.ResizeOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.GridLayoutScreenCanvasSizeOptions) : this() {
            this.optimizedViewPortWidth = x.optimizedViewPortWidth
            this.resizeOption = x.resizeOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.GridLayoutScreenCanvasSizeOptions = GridLayoutScreenCanvasSizeOptions(this)

        internal fun correctErrors(): Builder {
            if (resizeOption == null) resizeOption = ResizeOption.SdkUnknown("no value provided")
            return this
        }
    }
}
