// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GenerateEmbedUrlForRegisteredUserRequest private constructor(builder: Builder) {
    /**
     * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.
     *
     * To include all subdomains under a specific domain to the allow list, use `*`. For example, `https:/&#47;*.sapp.amazon.com` includes all subdomains under `https://sapp.amazon.com`.
     */
    public val allowedDomains: List<String>? = builder.allowedDomains
    /**
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The experience that you want to embed. For registered users, you can embed Amazon QuickSight dashboards, Amazon QuickSight visuals, the Amazon QuickSight Q search bar, the Amazon QuickSight Generative Q&A experience, or the entire Amazon QuickSight console.
     */
    public val experienceConfiguration: aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration? = builder.experienceConfiguration
    /**
     * How many minutes the session is valid. The session lifetime must be in &#91;15-600&#93; minutes range.
     */
    public val sessionLifetimeInMinutes: kotlin.Long? = builder.sessionLifetimeInMinutes
    /**
     * The Amazon Resource Name for the registered user.
     */
    public val userArn: kotlin.String? = builder.userArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateEmbedUrlForRegisteredUserRequest(")
        append("allowedDomains=$allowedDomains,")
        append("awsAccountId=$awsAccountId,")
        append("experienceConfiguration=$experienceConfiguration,")
        append("sessionLifetimeInMinutes=$sessionLifetimeInMinutes,")
        append("userArn=$userArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedDomains?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (experienceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sessionLifetimeInMinutes?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateEmbedUrlForRegisteredUserRequest

        if (allowedDomains != other.allowedDomains) return false
        if (awsAccountId != other.awsAccountId) return false
        if (experienceConfiguration != other.experienceConfiguration) return false
        if (sessionLifetimeInMinutes != other.sessionLifetimeInMinutes) return false
        if (userArn != other.userArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.
         *
         * To include all subdomains under a specific domain to the allow list, use `*`. For example, `https:/&#47;*.sapp.amazon.com` includes all subdomains under `https://sapp.amazon.com`.
         */
        public var allowedDomains: List<String>? = null
        /**
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The experience that you want to embed. For registered users, you can embed Amazon QuickSight dashboards, Amazon QuickSight visuals, the Amazon QuickSight Q search bar, the Amazon QuickSight Generative Q&A experience, or the entire Amazon QuickSight console.
         */
        public var experienceConfiguration: aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration? = null
        /**
         * How many minutes the session is valid. The session lifetime must be in &#91;15-600&#93; minutes range.
         */
        public var sessionLifetimeInMinutes: kotlin.Long? = null
        /**
         * The Amazon Resource Name for the registered user.
         */
        public var userArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest) : this() {
            this.allowedDomains = x.allowedDomains
            this.awsAccountId = x.awsAccountId
            this.experienceConfiguration = x.experienceConfiguration
            this.sessionLifetimeInMinutes = x.sessionLifetimeInMinutes
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest = GenerateEmbedUrlForRegisteredUserRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration] inside the given [block]
         */
        public fun experienceConfiguration(block: aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration.Builder.() -> kotlin.Unit) {
            this.experienceConfiguration = aws.sdk.kotlin.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
