// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An element within a free-form layout.
 */
public class FreeFormLayoutElement private constructor(builder: Builder) {
    /**
     * The background style configuration of a free-form layout element.
     */
    public val backgroundStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBackgroundStyle? = builder.backgroundStyle
    /**
     * The border style configuration of a free-form layout element.
     */
    public val borderStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle? = builder.borderStyle
    /**
     * A unique identifier for an element within a free-form layout.
     */
    public val elementId: kotlin.String = requireNotNull(builder.elementId) { "A non-null value must be provided for elementId" }
    /**
     * The type of element.
     */
    public val elementType: aws.sdk.kotlin.services.quicksight.model.LayoutElementType = requireNotNull(builder.elementType) { "A non-null value must be provided for elementType" }
    /**
     * The height of an element within a free-form layout.
     */
    public val height: kotlin.String = requireNotNull(builder.height) { "A non-null value must be provided for height" }
    /**
     * The loading animation configuration of a free-form layout element.
     */
    public val loadingAnimation: aws.sdk.kotlin.services.quicksight.model.LoadingAnimation? = builder.loadingAnimation
    /**
     * The rendering rules that determine when an element should be displayed within a free-form layout.
     */
    public val renderingRules: List<SheetElementRenderingRule>? = builder.renderingRules
    /**
     * The border style configuration of a free-form layout element. This border style is used when the element is selected.
     */
    public val selectedBorderStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle? = builder.selectedBorderStyle
    /**
     * The visibility of an element within a free-form layout.
     */
    public val visibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = builder.visibility
    /**
     * The width of an element within a free-form layout.
     */
    public val width: kotlin.String = requireNotNull(builder.width) { "A non-null value must be provided for width" }
    /**
     * The x-axis coordinate of the element.
     */
    public val xAxisLocation: kotlin.String = requireNotNull(builder.xAxisLocation) { "A non-null value must be provided for xAxisLocation" }
    /**
     * The y-axis coordinate of the element.
     */
    public val yAxisLocation: kotlin.String = requireNotNull(builder.yAxisLocation) { "A non-null value must be provided for yAxisLocation" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FreeFormLayoutElement(")
        append("backgroundStyle=$backgroundStyle,")
        append("borderStyle=$borderStyle,")
        append("elementId=$elementId,")
        append("elementType=$elementType,")
        append("height=$height,")
        append("loadingAnimation=$loadingAnimation,")
        append("renderingRules=$renderingRules,")
        append("selectedBorderStyle=$selectedBorderStyle,")
        append("visibility=$visibility,")
        append("width=$width,")
        append("xAxisLocation=$xAxisLocation,")
        append("yAxisLocation=$yAxisLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backgroundStyle?.hashCode() ?: 0
        result = 31 * result + (borderStyle?.hashCode() ?: 0)
        result = 31 * result + (elementId.hashCode())
        result = 31 * result + (elementType.hashCode())
        result = 31 * result + (height.hashCode())
        result = 31 * result + (loadingAnimation?.hashCode() ?: 0)
        result = 31 * result + (renderingRules?.hashCode() ?: 0)
        result = 31 * result + (selectedBorderStyle?.hashCode() ?: 0)
        result = 31 * result + (visibility?.hashCode() ?: 0)
        result = 31 * result + (width.hashCode())
        result = 31 * result + (xAxisLocation.hashCode())
        result = 31 * result + (yAxisLocation.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FreeFormLayoutElement

        if (backgroundStyle != other.backgroundStyle) return false
        if (borderStyle != other.borderStyle) return false
        if (elementId != other.elementId) return false
        if (elementType != other.elementType) return false
        if (height != other.height) return false
        if (loadingAnimation != other.loadingAnimation) return false
        if (renderingRules != other.renderingRules) return false
        if (selectedBorderStyle != other.selectedBorderStyle) return false
        if (visibility != other.visibility) return false
        if (width != other.width) return false
        if (xAxisLocation != other.xAxisLocation) return false
        if (yAxisLocation != other.yAxisLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The background style configuration of a free-form layout element.
         */
        public var backgroundStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBackgroundStyle? = null
        /**
         * The border style configuration of a free-form layout element.
         */
        public var borderStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle? = null
        /**
         * A unique identifier for an element within a free-form layout.
         */
        public var elementId: kotlin.String? = null
        /**
         * The type of element.
         */
        public var elementType: aws.sdk.kotlin.services.quicksight.model.LayoutElementType? = null
        /**
         * The height of an element within a free-form layout.
         */
        public var height: kotlin.String? = null
        /**
         * The loading animation configuration of a free-form layout element.
         */
        public var loadingAnimation: aws.sdk.kotlin.services.quicksight.model.LoadingAnimation? = null
        /**
         * The rendering rules that determine when an element should be displayed within a free-form layout.
         */
        public var renderingRules: List<SheetElementRenderingRule>? = null
        /**
         * The border style configuration of a free-form layout element. This border style is used when the element is selected.
         */
        public var selectedBorderStyle: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle? = null
        /**
         * The visibility of an element within a free-form layout.
         */
        public var visibility: aws.sdk.kotlin.services.quicksight.model.Visibility? = null
        /**
         * The width of an element within a free-form layout.
         */
        public var width: kotlin.String? = null
        /**
         * The x-axis coordinate of the element.
         */
        public var xAxisLocation: kotlin.String? = null
        /**
         * The y-axis coordinate of the element.
         */
        public var yAxisLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElement) : this() {
            this.backgroundStyle = x.backgroundStyle
            this.borderStyle = x.borderStyle
            this.elementId = x.elementId
            this.elementType = x.elementType
            this.height = x.height
            this.loadingAnimation = x.loadingAnimation
            this.renderingRules = x.renderingRules
            this.selectedBorderStyle = x.selectedBorderStyle
            this.visibility = x.visibility
            this.width = x.width
            this.xAxisLocation = x.xAxisLocation
            this.yAxisLocation = x.yAxisLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElement = FreeFormLayoutElement(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBackgroundStyle] inside the given [block]
         */
        public fun backgroundStyle(block: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBackgroundStyle.Builder.() -> kotlin.Unit) {
            this.backgroundStyle = aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBackgroundStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle] inside the given [block]
         */
        public fun borderStyle(block: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle.Builder.() -> kotlin.Unit) {
            this.borderStyle = aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.LoadingAnimation] inside the given [block]
         */
        public fun loadingAnimation(block: aws.sdk.kotlin.services.quicksight.model.LoadingAnimation.Builder.() -> kotlin.Unit) {
            this.loadingAnimation = aws.sdk.kotlin.services.quicksight.model.LoadingAnimation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle] inside the given [block]
         */
        public fun selectedBorderStyle(block: aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle.Builder.() -> kotlin.Unit) {
            this.selectedBorderStyle = aws.sdk.kotlin.services.quicksight.model.FreeFormLayoutElementBorderStyle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (elementId == null) elementId = ""
            if (elementType == null) elementType = LayoutElementType.SdkUnknown("no value provided")
            if (height == null) height = ""
            if (width == null) width = ""
            if (xAxisLocation == null) xAxisLocation = ""
            if (yAxisLocation == null) yAxisLocation = ""
            return this
        }
    }
}
