// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The forecast computation configuration.
 */
public class ForecastComputation private constructor(builder: Builder) {
    /**
     * The ID for a computation.
     */
    public val computationId: kotlin.String = requireNotNull(builder.computationId) { "A non-null value must be provided for computationId" }
    /**
     * The custom seasonality value setup of a forecast computation.
     */
    public val customSeasonalityValue: kotlin.Int? = builder.customSeasonalityValue
    /**
     * The lower boundary setup of a forecast computation.
     */
    public val lowerBoundary: kotlin.Double? = builder.lowerBoundary
    /**
     * The name of a computation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The periods backward setup of a forecast computation.
     */
    public val periodsBackward: kotlin.Int? = builder.periodsBackward
    /**
     * The periods forward setup of a forecast computation.
     */
    public val periodsForward: kotlin.Int? = builder.periodsForward
    /**
     * The prediction interval setup of a forecast computation.
     */
    public val predictionInterval: kotlin.Int? = builder.predictionInterval
    /**
     * The seasonality setup of a forecast computation. Choose one of the following options:
     * + `AUTOMATIC`
     * + `CUSTOM`: Checks the custom seasonality value.
     */
    public val seasonality: aws.sdk.kotlin.services.quicksight.model.ForecastComputationSeasonality? = builder.seasonality
    /**
     * The time field that is used in a computation.
     */
    public val time: aws.sdk.kotlin.services.quicksight.model.DimensionField? = builder.time
    /**
     * The upper boundary setup of a forecast computation.
     */
    public val upperBoundary: kotlin.Double? = builder.upperBoundary
    /**
     * The value field that is used in a computation.
     */
    public val value: aws.sdk.kotlin.services.quicksight.model.MeasureField? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ForecastComputation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ForecastComputation(")
        append("computationId=$computationId,")
        append("customSeasonalityValue=$customSeasonalityValue,")
        append("lowerBoundary=$lowerBoundary,")
        append("name=$name,")
        append("periodsBackward=$periodsBackward,")
        append("periodsForward=$periodsForward,")
        append("predictionInterval=$predictionInterval,")
        append("seasonality=$seasonality,")
        append("time=$time,")
        append("upperBoundary=$upperBoundary,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computationId.hashCode()
        result = 31 * result + (customSeasonalityValue ?: 0)
        result = 31 * result + (lowerBoundary?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (periodsBackward ?: 0)
        result = 31 * result + (periodsForward ?: 0)
        result = 31 * result + (predictionInterval ?: 0)
        result = 31 * result + (seasonality?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (upperBoundary?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ForecastComputation

        if (computationId != other.computationId) return false
        if (customSeasonalityValue != other.customSeasonalityValue) return false
        if (!(lowerBoundary?.equals(other.lowerBoundary) ?: (other.lowerBoundary == null))) return false
        if (name != other.name) return false
        if (periodsBackward != other.periodsBackward) return false
        if (periodsForward != other.periodsForward) return false
        if (predictionInterval != other.predictionInterval) return false
        if (seasonality != other.seasonality) return false
        if (time != other.time) return false
        if (!(upperBoundary?.equals(other.upperBoundary) ?: (other.upperBoundary == null))) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ForecastComputation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for a computation.
         */
        public var computationId: kotlin.String? = null
        /**
         * The custom seasonality value setup of a forecast computation.
         */
        public var customSeasonalityValue: kotlin.Int? = null
        /**
         * The lower boundary setup of a forecast computation.
         */
        public var lowerBoundary: kotlin.Double? = null
        /**
         * The name of a computation.
         */
        public var name: kotlin.String? = null
        /**
         * The periods backward setup of a forecast computation.
         */
        public var periodsBackward: kotlin.Int? = null
        /**
         * The periods forward setup of a forecast computation.
         */
        public var periodsForward: kotlin.Int? = null
        /**
         * The prediction interval setup of a forecast computation.
         */
        public var predictionInterval: kotlin.Int? = null
        /**
         * The seasonality setup of a forecast computation. Choose one of the following options:
         * + `AUTOMATIC`
         * + `CUSTOM`: Checks the custom seasonality value.
         */
        public var seasonality: aws.sdk.kotlin.services.quicksight.model.ForecastComputationSeasonality? = null
        /**
         * The time field that is used in a computation.
         */
        public var time: aws.sdk.kotlin.services.quicksight.model.DimensionField? = null
        /**
         * The upper boundary setup of a forecast computation.
         */
        public var upperBoundary: kotlin.Double? = null
        /**
         * The value field that is used in a computation.
         */
        public var value: aws.sdk.kotlin.services.quicksight.model.MeasureField? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ForecastComputation) : this() {
            this.computationId = x.computationId
            this.customSeasonalityValue = x.customSeasonalityValue
            this.lowerBoundary = x.lowerBoundary
            this.name = x.name
            this.periodsBackward = x.periodsBackward
            this.periodsForward = x.periodsForward
            this.predictionInterval = x.predictionInterval
            this.seasonality = x.seasonality
            this.time = x.time
            this.upperBoundary = x.upperBoundary
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ForecastComputation = ForecastComputation(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DimensionField] inside the given [block]
         */
        public fun time(block: aws.sdk.kotlin.services.quicksight.model.DimensionField.Builder.() -> kotlin.Unit) {
            this.time = aws.sdk.kotlin.services.quicksight.model.DimensionField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.MeasureField] inside the given [block]
         */
        public fun value(block: aws.sdk.kotlin.services.quicksight.model.MeasureField.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.quicksight.model.MeasureField.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (computationId == null) computationId = ""
            return this
        }
    }
}
