// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter to use to search an Amazon QuickSight folder.
 */
public class FolderSearchFilter private constructor(builder: Builder) {
    /**
     * The name of a value that you want to use in the filter. For example, `"Name": "QUICKSIGHT_OWNER"`.
     *
     * Valid values are defined as follows:
     * + `QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the folder's owners or viewers are returned. Implicit permissions from folders or groups are considered.
     * + `QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are considered.
     * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as the only owner of the folder are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners or viewers of the folders are returned. Implicit permissions from folders or groups are not considered.
     * + `FOLDER_NAME`: Any folders whose names have a substring match to this value will be returned.
     * + `PARENT_FOLDER_ARN`: Provide an ARN of a folder, and any folders that are directly under that parent folder are returned. If you choose to use this option and leave the value blank, all root-level folders in the account are returned.
     */
    public val name: aws.sdk.kotlin.services.quicksight.model.FolderFilterAttribute? = builder.name
    /**
     * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
     *
     * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose folders you want to search in the `"Value"` field. For example, `"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
     *
     * If you set the value to `"StringLike"`, you need to provide the name of the folders you are searching for. For example, `"Name":"FOLDER_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `FOLDER_NAME`.
     */
    public val operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator? = builder.operator
    /**
     * The value of the named item (in this example, `PARENT_FOLDER_ARN`), that you want to use as a filter. For example, `"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"`.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FolderSearchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FolderSearchFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FolderSearchFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FolderSearchFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of a value that you want to use in the filter. For example, `"Name": "QUICKSIGHT_OWNER"`.
         *
         * Valid values are defined as follows:
         * + `QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the folder's owners or viewers are returned. Implicit permissions from folders or groups are considered.
         * + `QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are considered.
         * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as the only owner of the folder are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners or viewers of the folders are returned. Implicit permissions from folders or groups are not considered.
         * + `FOLDER_NAME`: Any folders whose names have a substring match to this value will be returned.
         * + `PARENT_FOLDER_ARN`: Provide an ARN of a folder, and any folders that are directly under that parent folder are returned. If you choose to use this option and leave the value blank, all root-level folders in the account are returned.
         */
        public var name: aws.sdk.kotlin.services.quicksight.model.FolderFilterAttribute? = null
        /**
         * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
         *
         * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose folders you want to search in the `"Value"` field. For example, `"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
         *
         * If you set the value to `"StringLike"`, you need to provide the name of the folders you are searching for. For example, `"Name":"FOLDER_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `FOLDER_NAME`.
         */
        public var operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator? = null
        /**
         * The value of the named item (in this example, `PARENT_FOLDER_ARN`), that you want to use as a filter. For example, `"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"`.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FolderSearchFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FolderSearchFilter = FolderSearchFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
