// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
 */
public class FilterSliderControl private constructor(builder: Builder) {
    /**
     * The display options of a control.
     */
    public val displayOptions: aws.sdk.kotlin.services.quicksight.model.SliderControlDisplayOptions? = builder.displayOptions
    /**
     * The ID of the `FilterSliderControl`.
     */
    public val filterControlId: kotlin.String = requireNotNull(builder.filterControlId) { "A non-null value must be provided for filterControlId" }
    /**
     * The larger value that is displayed at the right of the slider.
     */
    public val maximumValue: kotlin.Double = builder.maximumValue
    /**
     * The smaller value that is displayed at the left of the slider.
     */
    public val minimumValue: kotlin.Double = builder.minimumValue
    /**
     * The source filter ID of the `FilterSliderControl`.
     */
    public val sourceFilterId: kotlin.String = requireNotNull(builder.sourceFilterId) { "A non-null value must be provided for sourceFilterId" }
    /**
     * The number of increments that the slider bar is divided into.
     */
    public val stepSize: kotlin.Double = builder.stepSize
    /**
     * The title of the `FilterSliderControl`.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The type of the `FilterSliderControl`. Choose one of the following options:
     * + `SINGLE_POINT`: Filter against(equals) a single data point.
     * + `RANGE`: Filter data that is in a specified range.
     */
    public val type: aws.sdk.kotlin.services.quicksight.model.SheetControlSliderType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FilterSliderControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilterSliderControl(")
        append("displayOptions=$displayOptions,")
        append("filterControlId=$filterControlId,")
        append("maximumValue=$maximumValue,")
        append("minimumValue=$minimumValue,")
        append("sourceFilterId=$sourceFilterId,")
        append("stepSize=$stepSize,")
        append("title=$title,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = displayOptions?.hashCode() ?: 0
        result = 31 * result + (filterControlId.hashCode())
        result = 31 * result + (maximumValue.hashCode())
        result = 31 * result + (minimumValue.hashCode())
        result = 31 * result + (sourceFilterId.hashCode())
        result = 31 * result + (stepSize.hashCode())
        result = 31 * result + (title.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilterSliderControl

        if (displayOptions != other.displayOptions) return false
        if (filterControlId != other.filterControlId) return false
        if (!(maximumValue?.equals(other.maximumValue) ?: (other.maximumValue == null))) return false
        if (!(minimumValue?.equals(other.minimumValue) ?: (other.minimumValue == null))) return false
        if (sourceFilterId != other.sourceFilterId) return false
        if (!(stepSize?.equals(other.stepSize) ?: (other.stepSize == null))) return false
        if (title != other.title) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FilterSliderControl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The display options of a control.
         */
        public var displayOptions: aws.sdk.kotlin.services.quicksight.model.SliderControlDisplayOptions? = null
        /**
         * The ID of the `FilterSliderControl`.
         */
        public var filterControlId: kotlin.String? = null
        /**
         * The larger value that is displayed at the right of the slider.
         */
        public var maximumValue: kotlin.Double = 0.0
        /**
         * The smaller value that is displayed at the left of the slider.
         */
        public var minimumValue: kotlin.Double = 0.0
        /**
         * The source filter ID of the `FilterSliderControl`.
         */
        public var sourceFilterId: kotlin.String? = null
        /**
         * The number of increments that the slider bar is divided into.
         */
        public var stepSize: kotlin.Double = 0.0
        /**
         * The title of the `FilterSliderControl`.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the `FilterSliderControl`. Choose one of the following options:
         * + `SINGLE_POINT`: Filter against(equals) a single data point.
         * + `RANGE`: Filter data that is in a specified range.
         */
        public var type: aws.sdk.kotlin.services.quicksight.model.SheetControlSliderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FilterSliderControl) : this() {
            this.displayOptions = x.displayOptions
            this.filterControlId = x.filterControlId
            this.maximumValue = x.maximumValue
            this.minimumValue = x.minimumValue
            this.sourceFilterId = x.sourceFilterId
            this.stepSize = x.stepSize
            this.title = x.title
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FilterSliderControl = FilterSliderControl(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SliderControlDisplayOptions] inside the given [block]
         */
        public fun displayOptions(block: aws.sdk.kotlin.services.quicksight.model.SliderControlDisplayOptions.Builder.() -> kotlin.Unit) {
            this.displayOptions = aws.sdk.kotlin.services.quicksight.model.SliderControlDisplayOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterControlId == null) filterControlId = ""
            if (sourceFilterId == null) sourceFilterId = ""
            if (title == null) title = ""
            return this
        }
    }
}
