// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A grouping of individual filters. Filter groups are applied to the same group of visuals.
 *
 * For more information, see [Adding filter conditions (group filters) with AND and OR operators](https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html) in the *Amazon QuickSight User Guide*.
 */
public class FilterGroup private constructor(builder: Builder) {
    /**
     * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
     * + `ALL_DATASETS`
     * + `SINGLE_DATASET`
     */
    public val crossDataset: aws.sdk.kotlin.services.quicksight.model.CrossDatasetTypes = requireNotNull(builder.crossDataset) { "A non-null value must be provided for crossDataset" }
    /**
     * The value that uniquely identifies a `FilterGroup` within a dashboard, template, or analysis.
     */
    public val filterGroupId: kotlin.String = requireNotNull(builder.filterGroupId) { "A non-null value must be provided for filterGroupId" }
    /**
     * The list of filters that are present in a `FilterGroup`.
     */
    public val filters: List<Filter> = requireNotNull(builder.filters) { "A non-null value must be provided for filters" }
    /**
     * The configuration that specifies what scope to apply to a `FilterGroup`.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     */
    public val scopeConfiguration: aws.sdk.kotlin.services.quicksight.model.FilterScopeConfiguration? = builder.scopeConfiguration
    /**
     * The status of the `FilterGroup`.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.WidgetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FilterGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilterGroup(")
        append("crossDataset=$crossDataset,")
        append("filterGroupId=$filterGroupId,")
        append("filters=$filters,")
        append("scopeConfiguration=$scopeConfiguration,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = crossDataset.hashCode()
        result = 31 * result + (filterGroupId.hashCode())
        result = 31 * result + (filters.hashCode())
        result = 31 * result + (scopeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilterGroup

        if (crossDataset != other.crossDataset) return false
        if (filterGroupId != other.filterGroupId) return false
        if (filters != other.filters) return false
        if (scopeConfiguration != other.scopeConfiguration) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FilterGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
         * + `ALL_DATASETS`
         * + `SINGLE_DATASET`
         */
        public var crossDataset: aws.sdk.kotlin.services.quicksight.model.CrossDatasetTypes? = null
        /**
         * The value that uniquely identifies a `FilterGroup` within a dashboard, template, or analysis.
         */
        public var filterGroupId: kotlin.String? = null
        /**
         * The list of filters that are present in a `FilterGroup`.
         */
        public var filters: List<Filter>? = null
        /**
         * The configuration that specifies what scope to apply to a `FilterGroup`.
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         */
        public var scopeConfiguration: aws.sdk.kotlin.services.quicksight.model.FilterScopeConfiguration? = null
        /**
         * The status of the `FilterGroup`.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.WidgetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FilterGroup) : this() {
            this.crossDataset = x.crossDataset
            this.filterGroupId = x.filterGroupId
            this.filters = x.filters
            this.scopeConfiguration = x.scopeConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FilterGroup = FilterGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FilterScopeConfiguration] inside the given [block]
         */
        public fun scopeConfiguration(block: aws.sdk.kotlin.services.quicksight.model.FilterScopeConfiguration.Builder.() -> kotlin.Unit) {
            this.scopeConfiguration = aws.sdk.kotlin.services.quicksight.model.FilterScopeConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (crossDataset == null) crossDataset = CrossDatasetTypes.SdkUnknown("no value provided")
            if (filterGroupId == null) filterGroupId = ""
            if (filters == null) filters = emptyList()
            return this
        }
    }
}
