// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * With a `Filter`, you can remove portions of data from a particular visual or view.
 *
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * A `CategoryFilter` filters text values.
     *
     * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide*.
     */
    public val categoryFilter: aws.sdk.kotlin.services.quicksight.model.CategoryFilter? = builder.categoryFilter
    /**
     * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
     */
    public val nestedFilter: aws.sdk.kotlin.services.quicksight.model.NestedFilter? = builder.nestedFilter
    /**
     * A `NumericEqualityFilter` filters numeric values that equal or do not equal a given numeric value.
     */
    public val numericEqualityFilter: aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter? = builder.numericEqualityFilter
    /**
     * A `NumericRangeFilter` filters numeric values that are either inside or outside a given numeric range.
     */
    public val numericRangeFilter: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter? = builder.numericRangeFilter
    /**
     * A `RelativeDatesFilter` filters date values that are relative to a given date.
     */
    public val relativeDatesFilter: aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter? = builder.relativeDatesFilter
    /**
     * A `TimeEqualityFilter` filters date-time values that equal or do not equal a given date/time value.
     */
    public val timeEqualityFilter: aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter? = builder.timeEqualityFilter
    /**
     * A `TimeRangeFilter` filters date-time values that are either inside or outside a given date/time range.
     */
    public val timeRangeFilter: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter? = builder.timeRangeFilter
    /**
     * A `TopBottomFilter` filters data to the top or bottom values for a given column.
     */
    public val topBottomFilter: aws.sdk.kotlin.services.quicksight.model.TopBottomFilter? = builder.topBottomFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("categoryFilter=$categoryFilter,")
        append("nestedFilter=$nestedFilter,")
        append("numericEqualityFilter=$numericEqualityFilter,")
        append("numericRangeFilter=$numericRangeFilter,")
        append("relativeDatesFilter=$relativeDatesFilter,")
        append("timeEqualityFilter=$timeEqualityFilter,")
        append("timeRangeFilter=$timeRangeFilter,")
        append("topBottomFilter=$topBottomFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categoryFilter?.hashCode() ?: 0
        result = 31 * result + (nestedFilter?.hashCode() ?: 0)
        result = 31 * result + (numericEqualityFilter?.hashCode() ?: 0)
        result = 31 * result + (numericRangeFilter?.hashCode() ?: 0)
        result = 31 * result + (relativeDatesFilter?.hashCode() ?: 0)
        result = 31 * result + (timeEqualityFilter?.hashCode() ?: 0)
        result = 31 * result + (timeRangeFilter?.hashCode() ?: 0)
        result = 31 * result + (topBottomFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (categoryFilter != other.categoryFilter) return false
        if (nestedFilter != other.nestedFilter) return false
        if (numericEqualityFilter != other.numericEqualityFilter) return false
        if (numericRangeFilter != other.numericRangeFilter) return false
        if (relativeDatesFilter != other.relativeDatesFilter) return false
        if (timeEqualityFilter != other.timeEqualityFilter) return false
        if (timeRangeFilter != other.timeRangeFilter) return false
        if (topBottomFilter != other.topBottomFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.Filter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A `CategoryFilter` filters text values.
         *
         * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide*.
         */
        public var categoryFilter: aws.sdk.kotlin.services.quicksight.model.CategoryFilter? = null
        /**
         * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
         */
        public var nestedFilter: aws.sdk.kotlin.services.quicksight.model.NestedFilter? = null
        /**
         * A `NumericEqualityFilter` filters numeric values that equal or do not equal a given numeric value.
         */
        public var numericEqualityFilter: aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter? = null
        /**
         * A `NumericRangeFilter` filters numeric values that are either inside or outside a given numeric range.
         */
        public var numericRangeFilter: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter? = null
        /**
         * A `RelativeDatesFilter` filters date values that are relative to a given date.
         */
        public var relativeDatesFilter: aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter? = null
        /**
         * A `TimeEqualityFilter` filters date-time values that equal or do not equal a given date/time value.
         */
        public var timeEqualityFilter: aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter? = null
        /**
         * A `TimeRangeFilter` filters date-time values that are either inside or outside a given date/time range.
         */
        public var timeRangeFilter: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter? = null
        /**
         * A `TopBottomFilter` filters data to the top or bottom values for a given column.
         */
        public var topBottomFilter: aws.sdk.kotlin.services.quicksight.model.TopBottomFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.Filter) : this() {
            this.categoryFilter = x.categoryFilter
            this.nestedFilter = x.nestedFilter
            this.numericEqualityFilter = x.numericEqualityFilter
            this.numericRangeFilter = x.numericRangeFilter
            this.relativeDatesFilter = x.relativeDatesFilter
            this.timeEqualityFilter = x.timeEqualityFilter
            this.timeRangeFilter = x.timeRangeFilter
            this.topBottomFilter = x.topBottomFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.Filter = Filter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.CategoryFilter] inside the given [block]
         */
        public fun categoryFilter(block: aws.sdk.kotlin.services.quicksight.model.CategoryFilter.Builder.() -> kotlin.Unit) {
            this.categoryFilter = aws.sdk.kotlin.services.quicksight.model.CategoryFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.NestedFilter] inside the given [block]
         */
        public fun nestedFilter(block: aws.sdk.kotlin.services.quicksight.model.NestedFilter.Builder.() -> kotlin.Unit) {
            this.nestedFilter = aws.sdk.kotlin.services.quicksight.model.NestedFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter] inside the given [block]
         */
        public fun numericEqualityFilter(block: aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter.Builder.() -> kotlin.Unit) {
            this.numericEqualityFilter = aws.sdk.kotlin.services.quicksight.model.NumericEqualityFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter] inside the given [block]
         */
        public fun numericRangeFilter(block: aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter.Builder.() -> kotlin.Unit) {
            this.numericRangeFilter = aws.sdk.kotlin.services.quicksight.model.NumericRangeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter] inside the given [block]
         */
        public fun relativeDatesFilter(block: aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter.Builder.() -> kotlin.Unit) {
            this.relativeDatesFilter = aws.sdk.kotlin.services.quicksight.model.RelativeDatesFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter] inside the given [block]
         */
        public fun timeEqualityFilter(block: aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter.Builder.() -> kotlin.Unit) {
            this.timeEqualityFilter = aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter] inside the given [block]
         */
        public fun timeRangeFilter(block: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter.Builder.() -> kotlin.Unit) {
            this.timeRangeFilter = aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopBottomFilter] inside the given [block]
         */
        public fun topBottomFilter(block: aws.sdk.kotlin.services.quicksight.model.TopBottomFilter.Builder.() -> kotlin.Unit) {
            this.topBottomFilter = aws.sdk.kotlin.services.quicksight.model.TopBottomFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
