// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filled map.
 *
 * For more information, see [Creating filled maps](https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html) in the *Amazon QuickSight User Guide*.
 */
public class FilledMapVisual private constructor(builder: Builder) {
    /**
     * The list of custom actions that are configured for a visual.
     */
    public val actions: List<VisualCustomAction>? = builder.actions
    /**
     * The configuration settings of the visual.
     */
    public val chartConfiguration: aws.sdk.kotlin.services.quicksight.model.FilledMapConfiguration? = builder.chartConfiguration
    /**
     * The column hierarchy that is used during drill-downs and drill-ups.
     */
    public val columnHierarchies: List<ColumnHierarchy>? = builder.columnHierarchies
    /**
     * The conditional formatting of a `FilledMapVisual`.
     */
    public val conditionalFormatting: aws.sdk.kotlin.services.quicksight.model.FilledMapConditionalFormatting? = builder.conditionalFormatting
    /**
     * The subtitle that is displayed on the visual.
     */
    public val subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = builder.subtitle
    /**
     * The title that is displayed on the visual.
     */
    public val title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = builder.title
    /**
     * The alt text for the visual.
     */
    public val visualContentAltText: kotlin.String? = builder.visualContentAltText
    /**
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FilledMapVisual = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilledMapVisual(")
        append("actions=$actions,")
        append("chartConfiguration=$chartConfiguration,")
        append("columnHierarchies=$columnHierarchies,")
        append("conditionalFormatting=$conditionalFormatting,")
        append("subtitle=$subtitle,")
        append("title=$title,")
        append("visualContentAltText=$visualContentAltText,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (chartConfiguration?.hashCode() ?: 0)
        result = 31 * result + (columnHierarchies?.hashCode() ?: 0)
        result = 31 * result + (conditionalFormatting?.hashCode() ?: 0)
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (visualContentAltText?.hashCode() ?: 0)
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilledMapVisual

        if (actions != other.actions) return false
        if (chartConfiguration != other.chartConfiguration) return false
        if (columnHierarchies != other.columnHierarchies) return false
        if (conditionalFormatting != other.conditionalFormatting) return false
        if (subtitle != other.subtitle) return false
        if (title != other.title) return false
        if (visualContentAltText != other.visualContentAltText) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FilledMapVisual = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of custom actions that are configured for a visual.
         */
        public var actions: List<VisualCustomAction>? = null
        /**
         * The configuration settings of the visual.
         */
        public var chartConfiguration: aws.sdk.kotlin.services.quicksight.model.FilledMapConfiguration? = null
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         */
        public var columnHierarchies: List<ColumnHierarchy>? = null
        /**
         * The conditional formatting of a `FilledMapVisual`.
         */
        public var conditionalFormatting: aws.sdk.kotlin.services.quicksight.model.FilledMapConditionalFormatting? = null
        /**
         * The subtitle that is displayed on the visual.
         */
        public var subtitle: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions? = null
        /**
         * The title that is displayed on the visual.
         */
        public var title: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions? = null
        /**
         * The alt text for the visual.
         */
        public var visualContentAltText: kotlin.String? = null
        /**
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FilledMapVisual) : this() {
            this.actions = x.actions
            this.chartConfiguration = x.chartConfiguration
            this.columnHierarchies = x.columnHierarchies
            this.conditionalFormatting = x.conditionalFormatting
            this.subtitle = x.subtitle
            this.title = x.title
            this.visualContentAltText = x.visualContentAltText
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FilledMapVisual = FilledMapVisual(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FilledMapConfiguration] inside the given [block]
         */
        public fun chartConfiguration(block: aws.sdk.kotlin.services.quicksight.model.FilledMapConfiguration.Builder.() -> kotlin.Unit) {
            this.chartConfiguration = aws.sdk.kotlin.services.quicksight.model.FilledMapConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.FilledMapConditionalFormatting] inside the given [block]
         */
        public fun conditionalFormatting(block: aws.sdk.kotlin.services.quicksight.model.FilledMapConditionalFormatting.Builder.() -> kotlin.Unit) {
            this.conditionalFormatting = aws.sdk.kotlin.services.quicksight.model.FilledMapConditionalFormatting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions] inside the given [block]
         */
        public fun subtitle(block: aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.subtitle = aws.sdk.kotlin.services.quicksight.model.VisualSubtitleLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions] inside the given [block]
         */
        public fun title(block: aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.Builder.() -> kotlin.Unit) {
            this.title = aws.sdk.kotlin.services.quicksight.model.VisualTitleLabelOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (visualId == null) visualId = ""
            return this
        }
    }
}
