// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An entry that appears when a `KeyRegistration` update to Amazon QuickSight fails.
 */
public class FailedKeyRegistrationEntry private constructor(builder: Builder) {
    /**
     * The ARN of the KMS key that failed to update.
     */
    public val keyArn: kotlin.String? = builder.keyArn
    /**
     * A message that provides information about why a `FailedKeyRegistrationEntry` error occurred.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * A boolean that indicates whether a `FailedKeyRegistrationEntry` resulted from user error. If the value of this property is `True`, the error was caused by user error. If the value of this property is `False`, the error occurred on the backend. If your job continues fail and with a `False``SenderFault` value, contact Amazon Web ServicesSupport.
     */
    public val senderFault: kotlin.Boolean = builder.senderFault
    /**
     * The HTTP status of a `FailedKeyRegistrationEntry` error.
     */
    public val statusCode: kotlin.Int = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.FailedKeyRegistrationEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailedKeyRegistrationEntry(")
        append("keyArn=$keyArn,")
        append("message=$message,")
        append("senderFault=$senderFault,")
        append("statusCode=$statusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyArn?.hashCode() ?: 0
        result = 31 * result + (message.hashCode())
        result = 31 * result + (senderFault.hashCode())
        result = 31 * result + (statusCode)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailedKeyRegistrationEntry

        if (keyArn != other.keyArn) return false
        if (message != other.message) return false
        if (senderFault != other.senderFault) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.FailedKeyRegistrationEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the KMS key that failed to update.
         */
        public var keyArn: kotlin.String? = null
        /**
         * A message that provides information about why a `FailedKeyRegistrationEntry` error occurred.
         */
        public var message: kotlin.String? = null
        /**
         * A boolean that indicates whether a `FailedKeyRegistrationEntry` resulted from user error. If the value of this property is `True`, the error was caused by user error. If the value of this property is `False`, the error occurred on the backend. If your job continues fail and with a `False``SenderFault` value, contact Amazon Web ServicesSupport.
         */
        public var senderFault: kotlin.Boolean = false
        /**
         * The HTTP status of a `FailedKeyRegistrationEntry` error.
         */
        public var statusCode: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.FailedKeyRegistrationEntry) : this() {
            this.keyArn = x.keyArn
            this.message = x.message
            this.senderFault = x.senderFault
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.FailedKeyRegistrationEntry = FailedKeyRegistrationEntry(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
