// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An empty visual.
 *
 * Empty visuals are used in layouts but have not been configured to show any data. A new visual created in the Amazon QuickSight console is considered an `EmptyVisual` until a visual type is selected.
 */
public class EmptyVisual private constructor(builder: Builder) {
    /**
     * The list of custom actions that are configured for a visual.
     */
    public val actions: List<VisualCustomAction>? = builder.actions
    /**
     * The data set that is used in the empty visual. Every visual requires a dataset to render.
     */
    public val dataSetIdentifier: kotlin.String = requireNotNull(builder.dataSetIdentifier) { "A non-null value must be provided for dataSetIdentifier" }
    /**
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.EmptyVisual = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmptyVisual(")
        append("actions=$actions,")
        append("dataSetIdentifier=$dataSetIdentifier,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (dataSetIdentifier.hashCode())
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmptyVisual

        if (actions != other.actions) return false
        if (dataSetIdentifier != other.dataSetIdentifier) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.EmptyVisual = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of custom actions that are configured for a visual.
         */
        public var actions: List<VisualCustomAction>? = null
        /**
         * The data set that is used in the empty visual. Every visual requires a dataset to render.
         */
        public var dataSetIdentifier: kotlin.String? = null
        /**
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.EmptyVisual) : this() {
            this.actions = x.actions
            this.dataSetIdentifier = x.dataSetIdentifier
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.EmptyVisual = EmptyVisual(this)

        internal fun correctErrors(): Builder {
            if (dataSetIdentifier == null) dataSetIdentifier = ""
            if (visualId == null) visualId = ""
            return this
        }
    }
}
