// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDashboardSnapshotJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a `StartDashboardSnapshotJob` API call.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The time that the snapshot job was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ID of the dashboard that you have started a snapshot job for.
     */
    public val dashboardId: kotlin.String? = builder.dashboardId
    /**
     * Indicates the status of a job. The status updates as the job executes. This shows one of the following values.
     * + `COMPLETED` - The job was completed successfully.
     * + `FAILED` - The job failed to execute.
     * + `QUEUED` - The job is queued and hasn't started yet.
     * + `RUNNING` - The job is still running.
     */
    public val jobStatus: aws.sdk.kotlin.services.quicksight.model.SnapshotJobStatus? = builder.jobStatus
    /**
     * The time that the snapshot job status was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The Amazon Web Services request ID for this operation.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The snapshot configuration of the job. This information is provided when you make a `StartDashboardSnapshotJob` API call.
     */
    public val snapshotConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration? = builder.snapshotConfiguration
    /**
     * The ID of the job to be described. The job ID is set when you start a new job with a `StartDashboardSnapshotJob` API call.
     */
    public val snapshotJobId: kotlin.String? = builder.snapshotJobId
    /**
     * The HTTP status of the request
     */
    public val status: kotlin.Int = builder.status
    /**
     * The user configuration for the snapshot job. This information is provided when you make a `StartDashboardSnapshotJob` API call.
     */
    public val userConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted? = builder.userConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDashboardSnapshotJobResponse(")
        append("arn=$arn,")
        append("awsAccountId=$awsAccountId,")
        append("createdTime=$createdTime,")
        append("dashboardId=$dashboardId,")
        append("jobStatus=$jobStatus,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("requestId=$requestId,")
        append("snapshotConfiguration=$snapshotConfiguration,")
        append("snapshotJobId=$snapshotJobId,")
        append("status=$status,")
        append("userConfiguration=$userConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (snapshotConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotJobId?.hashCode() ?: 0)
        result = 31 * result + (status)
        result = 31 * result + (userConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDashboardSnapshotJobResponse

        if (arn != other.arn) return false
        if (awsAccountId != other.awsAccountId) return false
        if (createdTime != other.createdTime) return false
        if (dashboardId != other.dashboardId) return false
        if (jobStatus != other.jobStatus) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (requestId != other.requestId) return false
        if (snapshotConfiguration != other.snapshotConfiguration) return false
        if (snapshotJobId != other.snapshotJobId) return false
        if (status != other.status) return false
        if (userConfiguration != other.userConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a `StartDashboardSnapshotJob` API call.
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The time that the snapshot job was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the dashboard that you have started a snapshot job for.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * Indicates the status of a job. The status updates as the job executes. This shows one of the following values.
         * + `COMPLETED` - The job was completed successfully.
         * + `FAILED` - The job failed to execute.
         * + `QUEUED` - The job is queued and hasn't started yet.
         * + `RUNNING` - The job is still running.
         */
        public var jobStatus: aws.sdk.kotlin.services.quicksight.model.SnapshotJobStatus? = null
        /**
         * The time that the snapshot job status was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services request ID for this operation.
         */
        public var requestId: kotlin.String? = null
        /**
         * The snapshot configuration of the job. This information is provided when you make a `StartDashboardSnapshotJob` API call.
         */
        public var snapshotConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration? = null
        /**
         * The ID of the job to be described. The job ID is set when you start a new job with a `StartDashboardSnapshotJob` API call.
         */
        public var snapshotJobId: kotlin.String? = null
        /**
         * The HTTP status of the request
         */
        public var status: kotlin.Int = 0
        /**
         * The user configuration for the snapshot job. This information is provided when you make a `StartDashboardSnapshotJob` API call.
         */
        public var userConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse) : this() {
            this.arn = x.arn
            this.awsAccountId = x.awsAccountId
            this.createdTime = x.createdTime
            this.dashboardId = x.dashboardId
            this.jobStatus = x.jobStatus
            this.lastUpdatedTime = x.lastUpdatedTime
            this.requestId = x.requestId
            this.snapshotConfiguration = x.snapshotConfiguration
            this.snapshotJobId = x.snapshotJobId
            this.status = x.status
            this.userConfiguration = x.userConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse = DescribeDashboardSnapshotJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration] inside the given [block]
         */
        public fun snapshotConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration.Builder.() -> kotlin.Unit) {
            this.snapshotConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted] inside the given [block]
         */
        public fun userConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted.Builder.() -> kotlin.Unit) {
            this.userConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
