// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeDashboardDefinitionResponse private constructor(builder: Builder) {
    /**
     * The ID of the dashboard described.
     */
    public val dashboardId: kotlin.String? = builder.dashboardId
    /**
     * Options for publishing the dashboard:
     * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
     * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
     * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
     */
    public val dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = builder.dashboardPublishOptions
    /**
     * The definition of a dashboard.
     *
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public val definition: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition? = builder.definition
    /**
     * Errors associated with this dashboard version.
     */
    public val errors: List<DashboardError>? = builder.errors
    /**
     * The display name of the dashboard.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services request ID for this operation.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * Status associated with the dashboard version.
     * + `CREATION_IN_PROGRESS`
     * + `CREATION_SUCCESSFUL`
     * + `CREATION_FAILED`
     * + `UPDATE_IN_PROGRESS`
     * + `UPDATE_SUCCESSFUL`
     * + `UPDATE_FAILED`
     * + `DELETED`
     */
    public val resourceStatus: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = builder.resourceStatus
    /**
     * The HTTP status of the request.
     */
    public val status: kotlin.Int = builder.status
    /**
     * The ARN of the theme of the dashboard.
     */
    public val themeArn: kotlin.String? = builder.themeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDashboardDefinitionResponse(")
        append("dashboardId=$dashboardId,")
        append("dashboardPublishOptions=$dashboardPublishOptions,")
        append("definition=$definition,")
        append("errors=$errors,")
        append("name=$name,")
        append("requestId=$requestId,")
        append("resourceStatus=$resourceStatus,")
        append("status=$status,")
        append("themeArn=$themeArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboardId?.hashCode() ?: 0
        result = 31 * result + (dashboardPublishOptions?.hashCode() ?: 0)
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (resourceStatus?.hashCode() ?: 0)
        result = 31 * result + (status)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDashboardDefinitionResponse

        if (dashboardId != other.dashboardId) return false
        if (dashboardPublishOptions != other.dashboardPublishOptions) return false
        if (definition != other.definition) return false
        if (errors != other.errors) return false
        if (name != other.name) return false
        if (requestId != other.requestId) return false
        if (resourceStatus != other.resourceStatus) return false
        if (status != other.status) return false
        if (themeArn != other.themeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the dashboard described.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * Options for publishing the dashboard:
         * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
         * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
         * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
         */
        public var dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = null
        /**
         * The definition of a dashboard.
         *
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         */
        public var definition: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition? = null
        /**
         * Errors associated with this dashboard version.
         */
        public var errors: List<DashboardError>? = null
        /**
         * The display name of the dashboard.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services request ID for this operation.
         */
        public var requestId: kotlin.String? = null
        /**
         * Status associated with the dashboard version.
         * + `CREATION_IN_PROGRESS`
         * + `CREATION_SUCCESSFUL`
         * + `CREATION_FAILED`
         * + `UPDATE_IN_PROGRESS`
         * + `UPDATE_SUCCESSFUL`
         * + `UPDATE_FAILED`
         * + `DELETED`
         */
        public var resourceStatus: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = null
        /**
         * The HTTP status of the request.
         */
        public var status: kotlin.Int = 0
        /**
         * The ARN of the theme of the dashboard.
         */
        public var themeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse) : this() {
            this.dashboardId = x.dashboardId
            this.dashboardPublishOptions = x.dashboardPublishOptions
            this.definition = x.definition
            this.errors = x.errors
            this.name = x.name
            this.requestId = x.requestId
            this.resourceStatus = x.resourceStatus
            this.status = x.status
            this.themeArn = x.themeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse = DescribeDashboardDefinitionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions] inside the given [block]
         */
        public fun dashboardPublishOptions(block: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.Builder.() -> kotlin.Unit) {
            this.dashboardPublishOptions = aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
