// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeAssetBundleExportJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the export job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ID of the job. The job ID is set when you start a new job with a `StartAssetBundleExportJob` API call.
     */
    public val assetBundleExportJobId: kotlin.String? = builder.assetBundleExportJobId
    /**
     * The ID of the Amazon Web Services account that the export job was executed in.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The CloudFormation override property configuration for the export job.
     */
    public val cloudFormationOverridePropertyConfiguration: aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration? = builder.cloudFormationOverridePropertyConfiguration
    /**
     * The time that the export job was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The URL to download the exported asset bundle data from.
     *
     * This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance. Call `DescribeAssetBundleExportJob` again for a fresh URL if needed.
     *
     * The downloaded asset bundle is a zip file named `assetbundle-{jobId}.qs`. The file has a `.qs` extension.
     *
     * This URL can't be used in a `StartAssetBundleImportJob` API call and should only be used for download purposes.
     */
    public val downloadUrl: kotlin.String? = builder.downloadUrl
    /**
     * An array of error records that describes any failures that occurred during the export job processing.
     *
     * Error records accumulate while the job runs. The complete set of error records is available after the job has completed and failed.
     */
    public val errors: List<AssetBundleExportJobError>? = builder.errors
    /**
     * The format of the exported asset bundle. A `QUICKSIGHT_JSON` formatted file can be used to make a `StartAssetBundleImportJob` API call. A `CLOUDFORMATION_JSON` formatted file can be used in the CloudFormation console and with the CloudFormation APIs.
     */
    public val exportFormat: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportFormat? = builder.exportFormat
    /**
     * The include dependencies flag.
     */
    public val includeAllDependencies: kotlin.Boolean = builder.includeAllDependencies
    /**
     * A setting that determines whether folder members are included.
     */
    public val includeFolderMembers: aws.sdk.kotlin.services.quicksight.model.IncludeFolderMembers? = builder.includeFolderMembers
    /**
     * The include folder memberships flag.
     */
    public val includeFolderMemberships: kotlin.Boolean = builder.includeFolderMemberships
    /**
     * The include permissions flag.
     */
    public val includePermissions: kotlin.Boolean = builder.includePermissions
    /**
     * The include tags flag.
     */
    public val includeTags: kotlin.Boolean = builder.includeTags
    /**
     * Indicates the status of a job through its queuing and execution.
     *
     * Poll this `DescribeAssetBundleExportApi` until `JobStatus` is either `SUCCESSFUL` or `FAILED`.
     */
    public val jobStatus: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobStatus? = builder.jobStatus
    /**
     * The Amazon Web Services request ID for this operation.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * A list of resource ARNs that exported with the job.
     */
    public val resourceArns: List<String>? = builder.resourceArns
    /**
     * The HTTP status of the response.
     */
    public val status: kotlin.Int = builder.status
    /**
     * The validation strategy that is used to export the analysis or dashboard.
     */
    public val validationStrategy: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy? = builder.validationStrategy
    /**
     * An array of warning records that describe the analysis or dashboard that is exported. This array includes UI errors that can be skipped during the validation process.
     *
     * This property only appears if `StrictModeForAllResources` in `ValidationStrategy` is set to `FALSE`.
     */
    public val warnings: List<AssetBundleExportJobWarning>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAssetBundleExportJobResponse(")
        append("arn=$arn,")
        append("assetBundleExportJobId=$assetBundleExportJobId,")
        append("awsAccountId=$awsAccountId,")
        append("cloudFormationOverridePropertyConfiguration=$cloudFormationOverridePropertyConfiguration,")
        append("createdTime=$createdTime,")
        append("downloadUrl=*** Sensitive Data Redacted ***,")
        append("errors=$errors,")
        append("exportFormat=$exportFormat,")
        append("includeAllDependencies=$includeAllDependencies,")
        append("includeFolderMembers=$includeFolderMembers,")
        append("includeFolderMemberships=$includeFolderMemberships,")
        append("includePermissions=$includePermissions,")
        append("includeTags=$includeTags,")
        append("jobStatus=$jobStatus,")
        append("requestId=$requestId,")
        append("resourceArns=$resourceArns,")
        append("status=$status,")
        append("validationStrategy=$validationStrategy,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assetBundleExportJobId?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (cloudFormationOverridePropertyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (downloadUrl?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (exportFormat?.hashCode() ?: 0)
        result = 31 * result + (includeAllDependencies.hashCode())
        result = 31 * result + (includeFolderMembers?.hashCode() ?: 0)
        result = 31 * result + (includeFolderMemberships.hashCode())
        result = 31 * result + (includePermissions.hashCode())
        result = 31 * result + (includeTags.hashCode())
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (status)
        result = 31 * result + (validationStrategy?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAssetBundleExportJobResponse

        if (arn != other.arn) return false
        if (assetBundleExportJobId != other.assetBundleExportJobId) return false
        if (awsAccountId != other.awsAccountId) return false
        if (cloudFormationOverridePropertyConfiguration != other.cloudFormationOverridePropertyConfiguration) return false
        if (createdTime != other.createdTime) return false
        if (downloadUrl != other.downloadUrl) return false
        if (errors != other.errors) return false
        if (exportFormat != other.exportFormat) return false
        if (includeAllDependencies != other.includeAllDependencies) return false
        if (includeFolderMembers != other.includeFolderMembers) return false
        if (includeFolderMemberships != other.includeFolderMemberships) return false
        if (includePermissions != other.includePermissions) return false
        if (includeTags != other.includeTags) return false
        if (jobStatus != other.jobStatus) return false
        if (requestId != other.requestId) return false
        if (resourceArns != other.resourceArns) return false
        if (status != other.status) return false
        if (validationStrategy != other.validationStrategy) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the export job.
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the job. The job ID is set when you start a new job with a `StartAssetBundleExportJob` API call.
         */
        public var assetBundleExportJobId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that the export job was executed in.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The CloudFormation override property configuration for the export job.
         */
        public var cloudFormationOverridePropertyConfiguration: aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration? = null
        /**
         * The time that the export job was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The URL to download the exported asset bundle data from.
         *
         * This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance. Call `DescribeAssetBundleExportJob` again for a fresh URL if needed.
         *
         * The downloaded asset bundle is a zip file named `assetbundle-{jobId}.qs`. The file has a `.qs` extension.
         *
         * This URL can't be used in a `StartAssetBundleImportJob` API call and should only be used for download purposes.
         */
        public var downloadUrl: kotlin.String? = null
        /**
         * An array of error records that describes any failures that occurred during the export job processing.
         *
         * Error records accumulate while the job runs. The complete set of error records is available after the job has completed and failed.
         */
        public var errors: List<AssetBundleExportJobError>? = null
        /**
         * The format of the exported asset bundle. A `QUICKSIGHT_JSON` formatted file can be used to make a `StartAssetBundleImportJob` API call. A `CLOUDFORMATION_JSON` formatted file can be used in the CloudFormation console and with the CloudFormation APIs.
         */
        public var exportFormat: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportFormat? = null
        /**
         * The include dependencies flag.
         */
        public var includeAllDependencies: kotlin.Boolean = false
        /**
         * A setting that determines whether folder members are included.
         */
        public var includeFolderMembers: aws.sdk.kotlin.services.quicksight.model.IncludeFolderMembers? = null
        /**
         * The include folder memberships flag.
         */
        public var includeFolderMemberships: kotlin.Boolean = false
        /**
         * The include permissions flag.
         */
        public var includePermissions: kotlin.Boolean = false
        /**
         * The include tags flag.
         */
        public var includeTags: kotlin.Boolean = false
        /**
         * Indicates the status of a job through its queuing and execution.
         *
         * Poll this `DescribeAssetBundleExportApi` until `JobStatus` is either `SUCCESSFUL` or `FAILED`.
         */
        public var jobStatus: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobStatus? = null
        /**
         * The Amazon Web Services request ID for this operation.
         */
        public var requestId: kotlin.String? = null
        /**
         * A list of resource ARNs that exported with the job.
         */
        public var resourceArns: List<String>? = null
        /**
         * The HTTP status of the response.
         */
        public var status: kotlin.Int = 0
        /**
         * The validation strategy that is used to export the analysis or dashboard.
         */
        public var validationStrategy: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy? = null
        /**
         * An array of warning records that describe the analysis or dashboard that is exported. This array includes UI errors that can be skipped during the validation process.
         *
         * This property only appears if `StrictModeForAllResources` in `ValidationStrategy` is set to `FALSE`.
         */
        public var warnings: List<AssetBundleExportJobWarning>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse) : this() {
            this.arn = x.arn
            this.assetBundleExportJobId = x.assetBundleExportJobId
            this.awsAccountId = x.awsAccountId
            this.cloudFormationOverridePropertyConfiguration = x.cloudFormationOverridePropertyConfiguration
            this.createdTime = x.createdTime
            this.downloadUrl = x.downloadUrl
            this.errors = x.errors
            this.exportFormat = x.exportFormat
            this.includeAllDependencies = x.includeAllDependencies
            this.includeFolderMembers = x.includeFolderMembers
            this.includeFolderMemberships = x.includeFolderMemberships
            this.includePermissions = x.includePermissions
            this.includeTags = x.includeTags
            this.jobStatus = x.jobStatus
            this.requestId = x.requestId
            this.resourceArns = x.resourceArns
            this.status = x.status
            this.validationStrategy = x.validationStrategy
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse = DescribeAssetBundleExportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration] inside the given [block]
         */
        public fun cloudFormationOverridePropertyConfiguration(block: aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudFormationOverridePropertyConfiguration = aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy] inside the given [block]
         */
        public fun validationStrategy(block: aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy.Builder.() -> kotlin.Unit) {
            this.validationStrategy = aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
