// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteAnalysisRequest private constructor(builder: Builder) {
    /**
     * The ID of the analysis that you're deleting.
     */
    public val analysisId: kotlin.String? = builder.analysisId
    /**
     * The ID of the Amazon Web Services account where you want to delete an analysis.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * This option defaults to the value `NoForceDeleteWithoutRecovery`. To immediately delete the analysis, add the `ForceDeleteWithoutRecovery` option. You can't restore an analysis after it's deleted.
     */
    public val forceDeleteWithoutRecovery: kotlin.Boolean? = builder.forceDeleteWithoutRecovery
    /**
     * A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the `ForceDeleteWithoutRecovery` option in the same API call. The default value is 30.
     */
    public val recoveryWindowInDays: kotlin.Long? = builder.recoveryWindowInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteAnalysisRequest(")
        append("analysisId=$analysisId,")
        append("awsAccountId=$awsAccountId,")
        append("forceDeleteWithoutRecovery=$forceDeleteWithoutRecovery,")
        append("recoveryWindowInDays=$recoveryWindowInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisId?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (forceDeleteWithoutRecovery?.hashCode() ?: 0)
        result = 31 * result + (recoveryWindowInDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteAnalysisRequest

        if (analysisId != other.analysisId) return false
        if (awsAccountId != other.awsAccountId) return false
        if (forceDeleteWithoutRecovery != other.forceDeleteWithoutRecovery) return false
        if (recoveryWindowInDays != other.recoveryWindowInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the analysis that you're deleting.
         */
        public var analysisId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account where you want to delete an analysis.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * This option defaults to the value `NoForceDeleteWithoutRecovery`. To immediately delete the analysis, add the `ForceDeleteWithoutRecovery` option. You can't restore an analysis after it's deleted.
         */
        public var forceDeleteWithoutRecovery: kotlin.Boolean? = null
        /**
         * A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the `ForceDeleteWithoutRecovery` option in the same API call. The default value is 30.
         */
        public var recoveryWindowInDays: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest) : this() {
            this.analysisId = x.analysisId
            this.awsAccountId = x.awsAccountId
            this.forceDeleteWithoutRecovery = x.forceDeleteWithoutRecovery
            this.recoveryWindowInDays = x.recoveryWindowInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest = DeleteAnalysisRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
