// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A date time parameter for a dataset.
 */
public class DateTimeDatasetParameter private constructor(builder: Builder) {
    /**
     * A list of default values for a given date time parameter. This structure only accepts static values.
     */
    public val defaultValues: aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameterDefaultValues? = builder.defaultValues
    /**
     * An identifier for the parameter that is created in the dataset.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the date time parameter that is created in the dataset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The time granularity of the date time parameter.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = builder.timeGranularity
    /**
     * The value type of the dataset parameter. Valid values are `single value` or `multi value`.
     */
    public val valueType: aws.sdk.kotlin.services.quicksight.model.DatasetParameterValueType = requireNotNull(builder.valueType) { "A non-null value must be provided for valueType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DateTimeDatasetParameter(")
        append("defaultValues=$defaultValues,")
        append("id=$id,")
        append("name=$name,")
        append("timeGranularity=$timeGranularity,")
        append("valueType=$valueType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValues?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (timeGranularity?.hashCode() ?: 0)
        result = 31 * result + (valueType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DateTimeDatasetParameter

        if (defaultValues != other.defaultValues) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (timeGranularity != other.timeGranularity) return false
        if (valueType != other.valueType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of default values for a given date time parameter. This structure only accepts static values.
         */
        public var defaultValues: aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameterDefaultValues? = null
        /**
         * An identifier for the parameter that is created in the dataset.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the date time parameter that is created in the dataset.
         */
        public var name: kotlin.String? = null
        /**
         * The time granularity of the date time parameter.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null
        /**
         * The value type of the dataset parameter. Valid values are `single value` or `multi value`.
         */
        public var valueType: aws.sdk.kotlin.services.quicksight.model.DatasetParameterValueType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameter) : this() {
            this.defaultValues = x.defaultValues
            this.id = x.id
            this.name = x.name
            this.timeGranularity = x.timeGranularity
            this.valueType = x.valueType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameter = DateTimeDatasetParameter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameterDefaultValues] inside the given [block]
         */
        public fun defaultValues(block: aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameterDefaultValues.Builder.() -> kotlin.Unit) {
            this.defaultValues = aws.sdk.kotlin.services.quicksight.model.DateTimeDatasetParameterDefaultValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (name == null) name = ""
            if (valueType == null) valueType = DatasetParameterValueType.SdkUnknown("no value provided")
            return this
        }
    }
}
