// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter that you apply when searching for data sources.
 */
public class DataSourceSearchFilter private constructor(builder: Builder) {
    /**
     * The name of the value that you want to use as a filter, for example, `"Name": "DIRECT_QUICKSIGHT_OWNER"`.
     *
     * Valid values are defined as follows:
     * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners or viewers of the data sources are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners if the data source are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as the only owner of the data source are returned. Implicit permissions from folders or groups are not considered.
     * + `DATASOURCE_NAME`: Any data sources whose names have a substring match to the provided value are returned.
     */
    public val name: aws.sdk.kotlin.services.quicksight.model.DataSourceFilterAttribute = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
     *
     * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose data sources you want to search in the `"Value"` field. For example, `"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
     *
     * If you set the value to `"StringLike"`, you need to provide the name of the data sources you are searching for. For example, `"Name":"DATASOURCE_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `DATASOURCE_NAME`.
     */
    public val operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The value of the named item, for example `DIRECT_QUICKSIGHT_OWNER`, that you want to use as a filter, for example, `"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DataSourceSearchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceSearchFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceSearchFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DataSourceSearchFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the value that you want to use as a filter, for example, `"Name": "DIRECT_QUICKSIGHT_OWNER"`.
         *
         * Valid values are defined as follows:
         * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners or viewers of the data sources are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners if the data source are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any data sources with that ARN listed as the only owner of the data source are returned. Implicit permissions from folders or groups are not considered.
         * + `DATASOURCE_NAME`: Any data sources whose names have a substring match to the provided value are returned.
         */
        public var name: aws.sdk.kotlin.services.quicksight.model.DataSourceFilterAttribute? = null
        /**
         * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
         *
         * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose data sources you want to search in the `"Value"` field. For example, `"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
         *
         * If you set the value to `"StringLike"`, you need to provide the name of the data sources you are searching for. For example, `"Name":"DATASOURCE_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `DATASOURCE_NAME`.
         */
        public var operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator? = null
        /**
         * The value of the named item, for example `DIRECT_QUICKSIGHT_OWNER`, that you want to use as a filter, for example, `"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DataSourceSearchFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DataSourceSearchFilter = DataSourceSearchFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = DataSourceFilterAttribute.SdkUnknown("no value provided")
            if (operator == null) operator = FilterOperator.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
