// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure of a data source.
 */
public class DataSource private constructor(builder: Builder) {
    /**
     * A set of alternate data source parameters that you want to share for the credentials stored with this data source. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the `DataSourceParameters` structure that's in the request with the structures in the `AlternateDataSourceParameters` allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the `AlternateDataSourceParameters` list is null, the `Credentials` originally used with this `DataSourceParameters` are automatically allowed.
     */
    public val alternateDataSourceParameters: List<DataSourceParameters>? = builder.alternateDataSourceParameters
    /**
     * The Amazon Resource Name (ARN) of the data source.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time that this data source was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     */
    public val dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = builder.dataSourceParameters
    /**
     * Error information from the last update or the creation of the data source.
     */
    public val errorInfo: aws.sdk.kotlin.services.quicksight.model.DataSourceErrorInfo? = builder.errorInfo
    /**
     * The last time that this data source was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * A display name for the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    public val sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = builder.sslProperties
    /**
     * The HTTP status of the request.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = builder.status
    /**
     * The type of the data source. This type indicates which database engine the data source connects to.
     */
    public val type: aws.sdk.kotlin.services.quicksight.model.DataSourceType? = builder.type
    /**
     * The VPC connection information. You need to use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    public val vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = builder.vpcConnectionProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("alternateDataSourceParameters=$alternateDataSourceParameters,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceParameters=$dataSourceParameters,")
        append("errorInfo=$errorInfo,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("secretArn=$secretArn,")
        append("sslProperties=$sslProperties,")
        append("status=$status,")
        append("type=$type,")
        append("vpcConnectionProperties=$vpcConnectionProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alternateDataSourceParameters?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceParameters?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sslProperties?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectionProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (alternateDataSourceParameters != other.alternateDataSourceParameters) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceParameters != other.dataSourceParameters) return false
        if (errorInfo != other.errorInfo) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (secretArn != other.secretArn) return false
        if (sslProperties != other.sslProperties) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (vpcConnectionProperties != other.vpcConnectionProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of alternate data source parameters that you want to share for the credentials stored with this data source. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the `DataSourceParameters` structure that's in the request with the structures in the `AlternateDataSourceParameters` allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the `AlternateDataSourceParameters` list is null, the `Credentials` originally used with this `DataSourceParameters` are automatically allowed.
         */
        public var alternateDataSourceParameters: List<DataSourceParameters>? = null
        /**
         * The Amazon Resource Name (ARN) of the data source.
         */
        public var arn: kotlin.String? = null
        /**
         * The time that this data source was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The parameters that Amazon QuickSight uses to connect to your underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
         */
        public var dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = null
        /**
         * Error information from the last update or the creation of the data source.
         */
        public var errorInfo: aws.sdk.kotlin.services.quicksight.model.DataSourceErrorInfo? = null
        /**
         * The last time that this data source was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A display name for the data source.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.
         */
        public var secretArn: kotlin.String? = null
        /**
         * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         */
        public var sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = null
        /**
         * The HTTP status of the request.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = null
        /**
         * The type of the data source. This type indicates which database engine the data source connects to.
         */
        public var type: aws.sdk.kotlin.services.quicksight.model.DataSourceType? = null
        /**
         * The VPC connection information. You need to use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         */
        public var vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DataSource) : this() {
            this.alternateDataSourceParameters = x.alternateDataSourceParameters
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.dataSourceId = x.dataSourceId
            this.dataSourceParameters = x.dataSourceParameters
            this.errorInfo = x.errorInfo
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.secretArn = x.secretArn
            this.sslProperties = x.sslProperties
            this.status = x.status
            this.type = x.type
            this.vpcConnectionProperties = x.vpcConnectionProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DataSource = DataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataSourceErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.quicksight.model.DataSourceErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.quicksight.model.DataSourceErrorInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SslProperties] inside the given [block]
         */
        public fun sslProperties(block: aws.sdk.kotlin.services.quicksight.model.SslProperties.Builder.() -> kotlin.Unit) {
            this.sslProperties = aws.sdk.kotlin.services.quicksight.model.SslProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties] inside the given [block]
         */
        public fun vpcConnectionProperties(block: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.Builder.() -> kotlin.Unit) {
            this.vpcConnectionProperties = aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
