// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter that you apply when searching for datasets.
 */
public class DataSetSearchFilter private constructor(builder: Builder) {
    /**
     * The name of the value that you want to use as a filter, for example, `"Name": "QUICKSIGHT_OWNER"`.
     *
     * Valid values are defined as follows:
     * + `QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the dataset owners or viewers are returned. Implicit permissions from folders or groups are considered.
     * + `QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners of the dataset are returned. Implicit permissions from folders or groups are considered.
     * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as the only owner of the dataset are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners if the dataset are returned. Implicit permissions from folders or groups are not considered.
     * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners or viewers of the dataset are returned. Implicit permissions from folders or groups are not considered.
     * + `DATASET_NAME`: Any datasets whose names have a substring match to this value will be returned.
     */
    public val name: aws.sdk.kotlin.services.quicksight.model.DataSetFilterAttribute = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
     *
     * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose datasets you want to search in the `"Value"` field. For example, `"Name":"QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east- 1:1:user/default/UserName1"`.
     *
     * If you set the value to `"StringLike"`, you need to provide the name of the datasets you are searching for. For example, `"Name":"DATASET_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `DATASET_NAME`.
     */
    public val operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The value of the named item, in this case `QUICKSIGHT_OWNER`, that you want to use as a filter, for example, `"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DataSetSearchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSetSearchFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSetSearchFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DataSetSearchFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the value that you want to use as a filter, for example, `"Name": "QUICKSIGHT_OWNER"`.
         *
         * Valid values are defined as follows:
         * + `QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the dataset owners or viewers are returned. Implicit permissions from folders or groups are considered.
         * + `QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners of the dataset are returned. Implicit permissions from folders or groups are considered.
         * + `DIRECT_QUICKSIGHT_SOLE_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as the only owner of the dataset are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners if the dataset are returned. Implicit permissions from folders or groups are not considered.
         * + `DIRECT_QUICKSIGHT_VIEWER_OR_OWNER`: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners or viewers of the dataset are returned. Implicit permissions from folders or groups are not considered.
         * + `DATASET_NAME`: Any datasets whose names have a substring match to this value will be returned.
         */
        public var name: aws.sdk.kotlin.services.quicksight.model.DataSetFilterAttribute? = null
        /**
         * The comparison operator that you want to use as a filter, for example `"Operator": "StringEquals"`. Valid values are `"StringEquals"` and `"StringLike"`.
         *
         * If you set the operator value to `"StringEquals"`, you need to provide an ownership related filter in the `"NAME"` field and the arn of the user or group whose datasets you want to search in the `"Value"` field. For example, `"Name":"QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east- 1:1:user/default/UserName1"`.
         *
         * If you set the value to `"StringLike"`, you need to provide the name of the datasets you are searching for. For example, `"Name":"DATASET_NAME", "Operator": "StringLike", "Value": "Test"`. The `"StringLike"` operator only supports the `NAME` value `DATASET_NAME`.
         */
        public var operator: aws.sdk.kotlin.services.quicksight.model.FilterOperator? = null
        /**
         * The value of the named item, in this case `QUICKSIGHT_OWNER`, that you want to use as a filter, for example, `"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"`.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DataSetSearchFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DataSetSearchFilter = DataSetSearchFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = DataSetFilterAttribute.SdkUnknown("no value provided")
            if (operator == null) operator = FilterOperator.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
