// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Dataset.
 */
public class DataSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.
     */
    public val columnGroups: List<ColumnGroup>? = builder.columnGroups
    /**
     * A set of one or more definitions of a ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> `.
     */
    public val columnLevelPermissionRules: List<ColumnLevelPermissionRule>? = builder.columnLevelPermissionRules
    /**
     * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
     */
    public val consumedSpiceCapacityInBytes: kotlin.Long = builder.consumedSpiceCapacityInBytes
    /**
     * The time that this dataset was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ID of the dataset. Limited to 96 characters.
     */
    public val dataSetId: kotlin.String? = builder.dataSetId
    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    public val dataSetUsageConfiguration: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration? = builder.dataSetUsageConfiguration
    /**
     * The parameters that are declared in a dataset.
     */
    public val datasetParameters: List<DatasetParameter>? = builder.datasetParameters
    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    public val fieldFolders: Map<String, FieldFolder>? = builder.fieldFolders
    /**
     * A value that indicates whether you want to import the data into SPICE.
     */
    public val importMode: aws.sdk.kotlin.services.quicksight.model.DataSetImportMode? = builder.importMode
    /**
     * The last time that this dataset was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    public val logicalTableMap: Map<String, LogicalTable>? = builder.logicalTableMap
    /**
     * A display name for the dataset.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
     */
    public val outputColumns: List<OutputColumn>? = builder.outputColumns
    /**
     * The performance optimization configuration of a dataset.
     */
    public val performanceConfiguration: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration? = builder.performanceConfiguration
    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    public val physicalTableMap: Map<String, PhysicalTable>? = builder.physicalTableMap
    /**
     * The row-level security configuration for the dataset.
     */
    public val rowLevelPermissionDataSet: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet? = builder.rowLevelPermissionDataSet
    /**
     * The element you can use to define tags for row-level security.
     */
    public val rowLevelPermissionTagConfiguration: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration? = builder.rowLevelPermissionTagConfiguration
    /**
     * The usage of the dataset.
     */
    public val useAs: aws.sdk.kotlin.services.quicksight.model.DataSetUseAs? = builder.useAs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DataSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSet(")
        append("arn=$arn,")
        append("columnGroups=$columnGroups,")
        append("columnLevelPermissionRules=$columnLevelPermissionRules,")
        append("consumedSpiceCapacityInBytes=$consumedSpiceCapacityInBytes,")
        append("createdTime=$createdTime,")
        append("dataSetId=$dataSetId,")
        append("dataSetUsageConfiguration=$dataSetUsageConfiguration,")
        append("datasetParameters=$datasetParameters,")
        append("fieldFolders=$fieldFolders,")
        append("importMode=$importMode,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("logicalTableMap=$logicalTableMap,")
        append("name=$name,")
        append("outputColumns=$outputColumns,")
        append("performanceConfiguration=$performanceConfiguration,")
        append("physicalTableMap=$physicalTableMap,")
        append("rowLevelPermissionDataSet=$rowLevelPermissionDataSet,")
        append("rowLevelPermissionTagConfiguration=$rowLevelPermissionTagConfiguration,")
        append("useAs=$useAs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (columnGroups?.hashCode() ?: 0)
        result = 31 * result + (columnLevelPermissionRules?.hashCode() ?: 0)
        result = 31 * result + (consumedSpiceCapacityInBytes.hashCode())
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dataSetId?.hashCode() ?: 0)
        result = 31 * result + (dataSetUsageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (datasetParameters?.hashCode() ?: 0)
        result = 31 * result + (fieldFolders?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (logicalTableMap?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputColumns?.hashCode() ?: 0)
        result = 31 * result + (performanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (physicalTableMap?.hashCode() ?: 0)
        result = 31 * result + (rowLevelPermissionDataSet?.hashCode() ?: 0)
        result = 31 * result + (rowLevelPermissionTagConfiguration?.hashCode() ?: 0)
        result = 31 * result + (useAs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSet

        if (arn != other.arn) return false
        if (columnGroups != other.columnGroups) return false
        if (columnLevelPermissionRules != other.columnLevelPermissionRules) return false
        if (consumedSpiceCapacityInBytes != other.consumedSpiceCapacityInBytes) return false
        if (createdTime != other.createdTime) return false
        if (dataSetId != other.dataSetId) return false
        if (dataSetUsageConfiguration != other.dataSetUsageConfiguration) return false
        if (datasetParameters != other.datasetParameters) return false
        if (fieldFolders != other.fieldFolders) return false
        if (importMode != other.importMode) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (logicalTableMap != other.logicalTableMap) return false
        if (name != other.name) return false
        if (outputColumns != other.outputColumns) return false
        if (performanceConfiguration != other.performanceConfiguration) return false
        if (physicalTableMap != other.physicalTableMap) return false
        if (rowLevelPermissionDataSet != other.rowLevelPermissionDataSet) return false
        if (rowLevelPermissionTagConfiguration != other.rowLevelPermissionTagConfiguration) return false
        if (useAs != other.useAs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DataSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.
         */
        public var columnGroups: List<ColumnGroup>? = null
        /**
         * A set of one or more definitions of a ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> `.
         */
        public var columnLevelPermissionRules: List<ColumnLevelPermissionRule>? = null
        /**
         * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
         */
        public var consumedSpiceCapacityInBytes: kotlin.Long = 0L
        /**
         * The time that this dataset was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the dataset. Limited to 96 characters.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         */
        public var dataSetUsageConfiguration: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration? = null
        /**
         * The parameters that are declared in a dataset.
         */
        public var datasetParameters: List<DatasetParameter>? = null
        /**
         * The folder that contains fields and nested subfolders for your dataset.
         */
        public var fieldFolders: Map<String, FieldFolder>? = null
        /**
         * A value that indicates whether you want to import the data into SPICE.
         */
        public var importMode: aws.sdk.kotlin.services.quicksight.model.DataSetImportMode? = null
        /**
         * The last time that this dataset was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configures the combination and transformation of the data from the physical tables.
         */
        public var logicalTableMap: Map<String, LogicalTable>? = null
        /**
         * A display name for the dataset.
         */
        public var name: kotlin.String? = null
        /**
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         */
        public var outputColumns: List<OutputColumn>? = null
        /**
         * The performance optimization configuration of a dataset.
         */
        public var performanceConfiguration: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration? = null
        /**
         * Declares the physical tables that are available in the underlying data sources.
         */
        public var physicalTableMap: Map<String, PhysicalTable>? = null
        /**
         * The row-level security configuration for the dataset.
         */
        public var rowLevelPermissionDataSet: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet? = null
        /**
         * The element you can use to define tags for row-level security.
         */
        public var rowLevelPermissionTagConfiguration: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration? = null
        /**
         * The usage of the dataset.
         */
        public var useAs: aws.sdk.kotlin.services.quicksight.model.DataSetUseAs? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DataSet) : this() {
            this.arn = x.arn
            this.columnGroups = x.columnGroups
            this.columnLevelPermissionRules = x.columnLevelPermissionRules
            this.consumedSpiceCapacityInBytes = x.consumedSpiceCapacityInBytes
            this.createdTime = x.createdTime
            this.dataSetId = x.dataSetId
            this.dataSetUsageConfiguration = x.dataSetUsageConfiguration
            this.datasetParameters = x.datasetParameters
            this.fieldFolders = x.fieldFolders
            this.importMode = x.importMode
            this.lastUpdatedTime = x.lastUpdatedTime
            this.logicalTableMap = x.logicalTableMap
            this.name = x.name
            this.outputColumns = x.outputColumns
            this.performanceConfiguration = x.performanceConfiguration
            this.physicalTableMap = x.physicalTableMap
            this.rowLevelPermissionDataSet = x.rowLevelPermissionDataSet
            this.rowLevelPermissionTagConfiguration = x.rowLevelPermissionTagConfiguration
            this.useAs = x.useAs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DataSet = DataSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration] inside the given [block]
         */
        public fun dataSetUsageConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSetUsageConfiguration = aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration] inside the given [block]
         */
        public fun performanceConfiguration(block: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration.Builder.() -> kotlin.Unit) {
            this.performanceConfiguration = aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet] inside the given [block]
         */
        public fun rowLevelPermissionDataSet(block: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet.Builder.() -> kotlin.Unit) {
            this.rowLevelPermissionDataSet = aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration] inside the given [block]
         */
        public fun rowLevelPermissionTagConfiguration(block: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration.Builder.() -> kotlin.Unit) {
            this.rowLevelPermissionTagConfiguration = aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
