// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains the following elements:
 * + The `DashboardId` of the dashboard that has the visual that you want to embed.
 * + The `SheetId` of the sheet that has the visual that you want to embed.
 * + The `VisualId` of the visual that you want to embed.
 *
 * The `DashboardId`, `SheetId`, and `VisualId` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console. You can also get the `DashboardId` with a `ListDashboards` API operation.
 */
public class DashboardVisualId private constructor(builder: Builder) {
    /**
     * The ID of the dashboard that has the visual that you want to embed. The `DashboardId` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console. You can also get the `DashboardId` with a `ListDashboards` API operation.
     */
    public val dashboardId: kotlin.String = requireNotNull(builder.dashboardId) { "A non-null value must be provided for dashboardId" }
    /**
     * The ID of the sheet that the has visual that you want to embed. The `SheetId` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console.
     */
    public val sheetId: kotlin.String = requireNotNull(builder.sheetId) { "A non-null value must be provided for sheetId" }
    /**
     * The ID of the visual that you want to embed. The `VisualID` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console.
     */
    public val visualId: kotlin.String = requireNotNull(builder.visualId) { "A non-null value must be provided for visualId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DashboardVisualId = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DashboardVisualId(")
        append("dashboardId=$dashboardId,")
        append("sheetId=$sheetId,")
        append("visualId=$visualId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboardId.hashCode()
        result = 31 * result + (sheetId.hashCode())
        result = 31 * result + (visualId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DashboardVisualId

        if (dashboardId != other.dashboardId) return false
        if (sheetId != other.sheetId) return false
        if (visualId != other.visualId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DashboardVisualId = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the dashboard that has the visual that you want to embed. The `DashboardId` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console. You can also get the `DashboardId` with a `ListDashboards` API operation.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * The ID of the sheet that the has visual that you want to embed. The `SheetId` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console.
         */
        public var sheetId: kotlin.String? = null
        /**
         * The ID of the visual that you want to embed. The `VisualID` can be found in the `IDs for developers` section of the `Embed visual` pane of the visual's on-visual menu of the Amazon QuickSight console.
         */
        public var visualId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DashboardVisualId) : this() {
            this.dashboardId = x.dashboardId
            this.sheetId = x.sheetId
            this.visualId = x.visualId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DashboardVisualId = DashboardVisualId(this)

        internal fun correctErrors(): Builder {
            if (dashboardId == null) dashboardId = ""
            if (sheetId == null) sheetId = ""
            if (visualId == null) visualId = ""
            return this
        }
    }
}
