// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTopicRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that you want to create a topic in.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Custom instructions for the topic.
     */
    public val customInstructions: aws.sdk.kotlin.services.quicksight.model.CustomInstructions? = builder.customInstructions
    /**
     * The Folder ARN of the folder that you want the topic to reside in.
     */
    public val folderArns: List<String>? = builder.folderArns
    /**
     * Contains a map of the key-value pairs for the resource tag or tags that are assigned to the dataset.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The definition of a topic to create.
     */
    public val topic: aws.sdk.kotlin.services.quicksight.model.TopicDetails? = builder.topic
    /**
     * The ID for the topic that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
     */
    public val topicId: kotlin.String? = builder.topicId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTopicRequest(")
        append("awsAccountId=$awsAccountId,")
        append("customInstructions=$customInstructions,")
        append("folderArns=$folderArns,")
        append("tags=$tags,")
        append("topic=$topic,")
        append("topicId=$topicId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (customInstructions?.hashCode() ?: 0)
        result = 31 * result + (folderArns?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (topic?.hashCode() ?: 0)
        result = 31 * result + (topicId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTopicRequest

        if (awsAccountId != other.awsAccountId) return false
        if (customInstructions != other.customInstructions) return false
        if (folderArns != other.folderArns) return false
        if (tags != other.tags) return false
        if (topic != other.topic) return false
        if (topicId != other.topicId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that you want to create a topic in.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Custom instructions for the topic.
         */
        public var customInstructions: aws.sdk.kotlin.services.quicksight.model.CustomInstructions? = null
        /**
         * The Folder ARN of the folder that you want the topic to reside in.
         */
        public var folderArns: List<String>? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags that are assigned to the dataset.
         */
        public var tags: List<Tag>? = null
        /**
         * The definition of a topic to create.
         */
        public var topic: aws.sdk.kotlin.services.quicksight.model.TopicDetails? = null
        /**
         * The ID for the topic that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
         */
        public var topicId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.customInstructions = x.customInstructions
            this.folderArns = x.folderArns
            this.tags = x.tags
            this.topic = x.topic
            this.topicId = x.topicId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest = CreateTopicRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.CustomInstructions] inside the given [block]
         */
        public fun customInstructions(block: aws.sdk.kotlin.services.quicksight.model.CustomInstructions.Builder.() -> kotlin.Unit) {
            this.customInstructions = aws.sdk.kotlin.services.quicksight.model.CustomInstructions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicDetails] inside the given [block]
         */
        public fun topic(block: aws.sdk.kotlin.services.quicksight.model.TopicDetails.Builder.() -> kotlin.Unit) {
            this.topic = aws.sdk.kotlin.services.quicksight.model.TopicDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
