// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDataSetRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.
     */
    public val columnGroups: List<ColumnGroup>? = builder.columnGroups
    /**
     * A set of one or more definitions of a ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> `.
     */
    public val columnLevelPermissionRules: List<ColumnLevelPermissionRule>? = builder.columnLevelPermissionRules
    /**
     * An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
     */
    public val dataSetId: kotlin.String? = builder.dataSetId
    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    public val dataSetUsageConfiguration: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration? = builder.dataSetUsageConfiguration
    /**
     * The parameter declarations of the dataset.
     */
    public val datasetParameters: List<DatasetParameter>? = builder.datasetParameters
    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    public val fieldFolders: Map<String, FieldFolder>? = builder.fieldFolders
    /**
     * When you create the dataset, Amazon QuickSight adds the dataset to these folders.
     */
    public val folderArns: List<String>? = builder.folderArns
    /**
     * Indicates whether you want to import the data into SPICE.
     */
    public val importMode: aws.sdk.kotlin.services.quicksight.model.DataSetImportMode? = builder.importMode
    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    public val logicalTableMap: Map<String, LogicalTable>? = builder.logicalTableMap
    /**
     * The display name for the dataset.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration for the performance optimization of the dataset that contains a `UniqueKey` configuration.
     */
    public val performanceConfiguration: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration? = builder.performanceConfiguration
    /**
     * A list of resource permissions on the dataset.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    public val physicalTableMap: Map<String, PhysicalTable>? = builder.physicalTableMap
    /**
     * The row-level security configuration for the data that you want to create.
     */
    public val rowLevelPermissionDataSet: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet? = builder.rowLevelPermissionDataSet
    /**
     * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.
     */
    public val rowLevelPermissionTagConfiguration: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration? = builder.rowLevelPermissionTagConfiguration
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The usage of the dataset. `RLS_RULES` must be specified for RLS permission datasets.
     */
    public val useAs: aws.sdk.kotlin.services.quicksight.model.DataSetUseAs? = builder.useAs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSetRequest(")
        append("awsAccountId=$awsAccountId,")
        append("columnGroups=$columnGroups,")
        append("columnLevelPermissionRules=$columnLevelPermissionRules,")
        append("dataSetId=$dataSetId,")
        append("dataSetUsageConfiguration=$dataSetUsageConfiguration,")
        append("datasetParameters=$datasetParameters,")
        append("fieldFolders=$fieldFolders,")
        append("folderArns=$folderArns,")
        append("importMode=$importMode,")
        append("logicalTableMap=$logicalTableMap,")
        append("name=$name,")
        append("performanceConfiguration=$performanceConfiguration,")
        append("permissions=$permissions,")
        append("physicalTableMap=$physicalTableMap,")
        append("rowLevelPermissionDataSet=$rowLevelPermissionDataSet,")
        append("rowLevelPermissionTagConfiguration=$rowLevelPermissionTagConfiguration,")
        append("tags=$tags,")
        append("useAs=$useAs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (columnGroups?.hashCode() ?: 0)
        result = 31 * result + (columnLevelPermissionRules?.hashCode() ?: 0)
        result = 31 * result + (dataSetId?.hashCode() ?: 0)
        result = 31 * result + (dataSetUsageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (datasetParameters?.hashCode() ?: 0)
        result = 31 * result + (fieldFolders?.hashCode() ?: 0)
        result = 31 * result + (folderArns?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (logicalTableMap?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (physicalTableMap?.hashCode() ?: 0)
        result = 31 * result + (rowLevelPermissionDataSet?.hashCode() ?: 0)
        result = 31 * result + (rowLevelPermissionTagConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useAs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSetRequest

        if (awsAccountId != other.awsAccountId) return false
        if (columnGroups != other.columnGroups) return false
        if (columnLevelPermissionRules != other.columnLevelPermissionRules) return false
        if (dataSetId != other.dataSetId) return false
        if (dataSetUsageConfiguration != other.dataSetUsageConfiguration) return false
        if (datasetParameters != other.datasetParameters) return false
        if (fieldFolders != other.fieldFolders) return false
        if (folderArns != other.folderArns) return false
        if (importMode != other.importMode) return false
        if (logicalTableMap != other.logicalTableMap) return false
        if (name != other.name) return false
        if (performanceConfiguration != other.performanceConfiguration) return false
        if (permissions != other.permissions) return false
        if (physicalTableMap != other.physicalTableMap) return false
        if (rowLevelPermissionDataSet != other.rowLevelPermissionDataSet) return false
        if (rowLevelPermissionTagConfiguration != other.rowLevelPermissionTagConfiguration) return false
        if (tags != other.tags) return false
        if (useAs != other.useAs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.
         */
        public var columnGroups: List<ColumnGroup>? = null
        /**
         * A set of one or more definitions of a ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> `.
         */
        public var columnLevelPermissionRules: List<ColumnLevelPermissionRule>? = null
        /**
         * An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         */
        public var dataSetUsageConfiguration: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration? = null
        /**
         * The parameter declarations of the dataset.
         */
        public var datasetParameters: List<DatasetParameter>? = null
        /**
         * The folder that contains fields and nested subfolders for your dataset.
         */
        public var fieldFolders: Map<String, FieldFolder>? = null
        /**
         * When you create the dataset, Amazon QuickSight adds the dataset to these folders.
         */
        public var folderArns: List<String>? = null
        /**
         * Indicates whether you want to import the data into SPICE.
         */
        public var importMode: aws.sdk.kotlin.services.quicksight.model.DataSetImportMode? = null
        /**
         * Configures the combination and transformation of the data from the physical tables.
         */
        public var logicalTableMap: Map<String, LogicalTable>? = null
        /**
         * The display name for the dataset.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration for the performance optimization of the dataset that contains a `UniqueKey` configuration.
         */
        public var performanceConfiguration: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration? = null
        /**
         * A list of resource permissions on the dataset.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * Declares the physical tables that are available in the underlying data sources.
         */
        public var physicalTableMap: Map<String, PhysicalTable>? = null
        /**
         * The row-level security configuration for the data that you want to create.
         */
        public var rowLevelPermissionDataSet: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet? = null
        /**
         * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.
         */
        public var rowLevelPermissionTagConfiguration: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         */
        public var tags: List<Tag>? = null
        /**
         * The usage of the dataset. `RLS_RULES` must be specified for RLS permission datasets.
         */
        public var useAs: aws.sdk.kotlin.services.quicksight.model.DataSetUseAs? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.columnGroups = x.columnGroups
            this.columnLevelPermissionRules = x.columnLevelPermissionRules
            this.dataSetId = x.dataSetId
            this.dataSetUsageConfiguration = x.dataSetUsageConfiguration
            this.datasetParameters = x.datasetParameters
            this.fieldFolders = x.fieldFolders
            this.folderArns = x.folderArns
            this.importMode = x.importMode
            this.logicalTableMap = x.logicalTableMap
            this.name = x.name
            this.performanceConfiguration = x.performanceConfiguration
            this.permissions = x.permissions
            this.physicalTableMap = x.physicalTableMap
            this.rowLevelPermissionDataSet = x.rowLevelPermissionDataSet
            this.rowLevelPermissionTagConfiguration = x.rowLevelPermissionTagConfiguration
            this.tags = x.tags
            this.useAs = x.useAs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest = CreateDataSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration] inside the given [block]
         */
        public fun dataSetUsageConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSetUsageConfiguration = aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration] inside the given [block]
         */
        public fun performanceConfiguration(block: aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration.Builder.() -> kotlin.Unit) {
            this.performanceConfiguration = aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet] inside the given [block]
         */
        public fun rowLevelPermissionDataSet(block: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet.Builder.() -> kotlin.Unit) {
            this.rowLevelPermissionDataSet = aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration] inside the given [block]
         */
        public fun rowLevelPermissionTagConfiguration(block: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration.Builder.() -> kotlin.Unit) {
            this.rowLevelPermissionTagConfiguration = aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
