// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDashboardRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account where you want to create the dashboard.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The ID for the dashboard, also added to the IAM policy.
     */
    public val dashboardId: kotlin.String? = builder.dashboardId
    /**
     * Options for publishing the dashboard when you create it:
     * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
     * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
     * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
     */
    public val dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = builder.dashboardPublishOptions
    /**
     * The definition of a dashboard.
     *
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     *
     * Either a `SourceEntity` or a `Definition` must be provided in order for the request to be valid.
     */
    public val definition: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition? = builder.definition
    /**
     * When you create the dashboard, Amazon QuickSight adds the dashboard to these folders.
     */
    public val folderArns: List<String>? = builder.folderArns
    /**
     * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
     */
    public val linkEntities: List<String>? = builder.linkEntities
    /**
     * A structure that contains the permissions of a shareable link to the dashboard.
     */
    public val linkSharingConfiguration: aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration? = builder.linkSharingConfiguration
    /**
     * The display name of the dashboard.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    public val parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = builder.parameters
    /**
     * A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
     *
     * To specify no permissions, omit the permissions list.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * The entity that you are using as a source when you create the dashboard. In `SourceEntity`, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a `SourceTemplate` entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation. For `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source template. The `SourceTemplate`ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
     *
     * Use the `DataSetReferences` entity within `SourceTemplate` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     *
     * Either a `SourceEntity` or a `Definition` must be provided in order for the request to be valid.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity? = builder.sourceEntity
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.
     */
    public val themeArn: kotlin.String? = builder.themeArn
    /**
     * The option to relax the validation needed to create a dashboard with definition objects. This option skips the validation step for specific errors.
     */
    public val validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = builder.validationStrategy
    /**
     * A description for the first version of the dashboard being created.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDashboardRequest(")
        append("awsAccountId=$awsAccountId,")
        append("dashboardId=$dashboardId,")
        append("dashboardPublishOptions=$dashboardPublishOptions,")
        append("definition=$definition,")
        append("folderArns=$folderArns,")
        append("linkEntities=$linkEntities,")
        append("linkSharingConfiguration=$linkSharingConfiguration,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("permissions=$permissions,")
        append("sourceEntity=$sourceEntity,")
        append("tags=$tags,")
        append("themeArn=$themeArn,")
        append("validationStrategy=$validationStrategy,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (dashboardPublishOptions?.hashCode() ?: 0)
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (folderArns?.hashCode() ?: 0)
        result = 31 * result + (linkEntities?.hashCode() ?: 0)
        result = 31 * result + (linkSharingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        result = 31 * result + (validationStrategy?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDashboardRequest

        if (awsAccountId != other.awsAccountId) return false
        if (dashboardId != other.dashboardId) return false
        if (dashboardPublishOptions != other.dashboardPublishOptions) return false
        if (definition != other.definition) return false
        if (folderArns != other.folderArns) return false
        if (linkEntities != other.linkEntities) return false
        if (linkSharingConfiguration != other.linkSharingConfiguration) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (permissions != other.permissions) return false
        if (sourceEntity != other.sourceEntity) return false
        if (tags != other.tags) return false
        if (themeArn != other.themeArn) return false
        if (validationStrategy != other.validationStrategy) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account where you want to create the dashboard.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The ID for the dashboard, also added to the IAM policy.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * Options for publishing the dashboard when you create it:
         * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
         * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
         * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
         */
        public var dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = null
        /**
         * The definition of a dashboard.
         *
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         *
         * Either a `SourceEntity` or a `Definition` must be provided in order for the request to be valid.
         */
        public var definition: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition? = null
        /**
         * When you create the dashboard, Amazon QuickSight adds the dashboard to these folders.
         */
        public var folderArns: List<String>? = null
        /**
         * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
         */
        public var linkEntities: List<String>? = null
        /**
         * A structure that contains the permissions of a shareable link to the dashboard.
         */
        public var linkSharingConfiguration: aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration? = null
        /**
         * The display name of the dashboard.
         */
        public var name: kotlin.String? = null
        /**
         * The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values.
         */
        public var parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = null
        /**
         * A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.
         *
         * To specify no permissions, omit the permissions list.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * The entity that you are using as a source when you create the dashboard. In `SourceEntity`, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a `SourceTemplate` entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation. For `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source template. The `SourceTemplate`ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
         *
         * Use the `DataSetReferences` entity within `SourceTemplate` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         *
         * Either a `SourceEntity` or a `Definition` must be provided in order for the request to be valid.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.
         */
        public var themeArn: kotlin.String? = null
        /**
         * The option to relax the validation needed to create a dashboard with definition objects. This option skips the validation step for specific errors.
         */
        public var validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = null
        /**
         * A description for the first version of the dashboard being created.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.dashboardId = x.dashboardId
            this.dashboardPublishOptions = x.dashboardPublishOptions
            this.definition = x.definition
            this.folderArns = x.folderArns
            this.linkEntities = x.linkEntities
            this.linkSharingConfiguration = x.linkSharingConfiguration
            this.name = x.name
            this.parameters = x.parameters
            this.permissions = x.permissions
            this.sourceEntity = x.sourceEntity
            this.tags = x.tags
            this.themeArn = x.themeArn
            this.validationStrategy = x.validationStrategy
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest = CreateDashboardRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions] inside the given [block]
         */
        public fun dashboardPublishOptions(block: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.Builder.() -> kotlin.Unit) {
            this.dashboardPublishOptions = aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration] inside the given [block]
         */
        public fun linkSharingConfiguration(block: aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration.Builder.() -> kotlin.Unit) {
            this.linkSharingConfiguration = aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.quicksight.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.quicksight.model.Parameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ValidationStrategy] inside the given [block]
         */
        public fun validationStrategy(block: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.Builder.() -> kotlin.Unit) {
            this.validationStrategy = aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
