// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAccountSubscriptionRequest private constructor(builder: Builder) {
    /**
     * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears only when users sign in. You can't change `AccountName` value after the Amazon QuickSight account is created.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val activeDirectoryName: kotlin.String? = builder.activeDirectoryName
    /**
     * The admin group associated with your Active Directory or IAM Identity Center account. Either this field or the `AdminProGroup` field is required if `ACTIVE_DIRECTORY` or `IAM_IDENTITY_CENTER` is the selected authentication method of the new Amazon QuickSight account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val adminGroup: List<String>? = builder.adminGroup
    /**
     * The admin pro group associated with your Active Directory or IAM Identity Center account. Either this field or the `AdminGroup` field is required if `ACTIVE_DIRECTORY` or `IAM_IDENTITY_CENTER` is the selected authentication method of the new Amazon QuickSight account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val adminProGroup: List<String>? = builder.adminProGroup
    /**
     * The method that you want to use to authenticate your Amazon QuickSight account.
     *
     * If you choose `ACTIVE_DIRECTORY`, provide an `ActiveDirectoryName` and an `AdminGroup` associated with your Active Directory.
     *
     * If you choose `IAM_IDENTITY_CENTER`, provide an `AdminGroup` associated with your IAM Identity Center account.
     */
    public val authenticationMethod: aws.sdk.kotlin.services.quicksight.model.AuthenticationMethodOption? = builder.authenticationMethod
    /**
     * The author group associated with your Active Directory or IAM Identity Center account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val authorGroup: List<String>? = builder.authorGroup
    /**
     * The author pro group associated with your Active Directory or IAM Identity Center account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val authorProGroup: List<String>? = builder.authorProGroup
    /**
     * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val contactNumber: kotlin.String? = builder.contactNumber
    /**
     * The ID of the Active Directory that is associated with your Amazon QuickSight account.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `ENTERPRISE` or `ENTERPRISE_AND_Q`.
     *
     * If you choose `ENTERPRISE_AND_Q`, the following parameters are required:
     * + `FirstName`
     * + `LastName`
     * + `EmailAddress`
     * + `ContactNumber`
     */
    public val edition: aws.sdk.kotlin.services.quicksight.model.Edition? = builder.edition
    /**
     * The email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * The first name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * The Amazon Resource Name (ARN) for the IAM Identity Center instance.
     */
    public val iamIdentityCenterInstanceArn: kotlin.String? = builder.iamIdentityCenterInstanceArn
    /**
     * The last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
     */
    public val notificationEmail: kotlin.String? = builder.notificationEmail
    /**
     * The reader group associated with your Active Directory or IAM Identity Center account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val readerGroup: List<String>? = builder.readerGroup
    /**
     * The reader pro group associated with your Active Directory or IAM Identity Center account.
     *
     * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val readerProGroup: List<String>? = builder.readerProGroup
    /**
     * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val realm: kotlin.String? = builder.realm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccountSubscriptionRequest(")
        append("accountName=$accountName,")
        append("activeDirectoryName=$activeDirectoryName,")
        append("adminGroup=$adminGroup,")
        append("adminProGroup=$adminProGroup,")
        append("authenticationMethod=$authenticationMethod,")
        append("authorGroup=$authorGroup,")
        append("authorProGroup=$authorProGroup,")
        append("awsAccountId=$awsAccountId,")
        append("contactNumber=$contactNumber,")
        append("directoryId=$directoryId,")
        append("edition=$edition,")
        append("emailAddress=$emailAddress,")
        append("firstName=$firstName,")
        append("iamIdentityCenterInstanceArn=$iamIdentityCenterInstanceArn,")
        append("lastName=$lastName,")
        append("notificationEmail=$notificationEmail,")
        append("readerGroup=$readerGroup,")
        append("readerProGroup=$readerProGroup,")
        append("realm=$realm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (activeDirectoryName?.hashCode() ?: 0)
        result = 31 * result + (adminGroup?.hashCode() ?: 0)
        result = 31 * result + (adminProGroup?.hashCode() ?: 0)
        result = 31 * result + (authenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (authorGroup?.hashCode() ?: 0)
        result = 31 * result + (authorProGroup?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (contactNumber?.hashCode() ?: 0)
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (iamIdentityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (notificationEmail?.hashCode() ?: 0)
        result = 31 * result + (readerGroup?.hashCode() ?: 0)
        result = 31 * result + (readerProGroup?.hashCode() ?: 0)
        result = 31 * result + (realm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccountSubscriptionRequest

        if (accountName != other.accountName) return false
        if (activeDirectoryName != other.activeDirectoryName) return false
        if (adminGroup != other.adminGroup) return false
        if (adminProGroup != other.adminProGroup) return false
        if (authenticationMethod != other.authenticationMethod) return false
        if (authorGroup != other.authorGroup) return false
        if (authorProGroup != other.authorProGroup) return false
        if (awsAccountId != other.awsAccountId) return false
        if (contactNumber != other.contactNumber) return false
        if (directoryId != other.directoryId) return false
        if (edition != other.edition) return false
        if (emailAddress != other.emailAddress) return false
        if (firstName != other.firstName) return false
        if (iamIdentityCenterInstanceArn != other.iamIdentityCenterInstanceArn) return false
        if (lastName != other.lastName) return false
        if (notificationEmail != other.notificationEmail) return false
        if (readerGroup != other.readerGroup) return false
        if (readerProGroup != other.readerProGroup) return false
        if (realm != other.realm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears only when users sign in. You can't change `AccountName` value after the Amazon QuickSight account is created.
         */
        public var accountName: kotlin.String? = null
        /**
         * The name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
         */
        public var activeDirectoryName: kotlin.String? = null
        /**
         * The admin group associated with your Active Directory or IAM Identity Center account. Either this field or the `AdminProGroup` field is required if `ACTIVE_DIRECTORY` or `IAM_IDENTITY_CENTER` is the selected authentication method of the new Amazon QuickSight account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var adminGroup: List<String>? = null
        /**
         * The admin pro group associated with your Active Directory or IAM Identity Center account. Either this field or the `AdminGroup` field is required if `ACTIVE_DIRECTORY` or `IAM_IDENTITY_CENTER` is the selected authentication method of the new Amazon QuickSight account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var adminProGroup: List<String>? = null
        /**
         * The method that you want to use to authenticate your Amazon QuickSight account.
         *
         * If you choose `ACTIVE_DIRECTORY`, provide an `ActiveDirectoryName` and an `AdminGroup` associated with your Active Directory.
         *
         * If you choose `IAM_IDENTITY_CENTER`, provide an `AdminGroup` associated with your IAM Identity Center account.
         */
        public var authenticationMethod: aws.sdk.kotlin.services.quicksight.model.AuthenticationMethodOption? = null
        /**
         * The author group associated with your Active Directory or IAM Identity Center account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var authorGroup: List<String>? = null
        /**
         * The author pro group associated with your Active Directory or IAM Identity Center account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var authorProGroup: List<String>? = null
        /**
         * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var contactNumber: kotlin.String? = null
        /**
         * The ID of the Active Directory that is associated with your Amazon QuickSight account.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `ENTERPRISE` or `ENTERPRISE_AND_Q`.
         *
         * If you choose `ENTERPRISE_AND_Q`, the following parameters are required:
         * + `FirstName`
         * + `LastName`
         * + `EmailAddress`
         * + `ContactNumber`
         */
        public var edition: aws.sdk.kotlin.services.quicksight.model.Edition? = null
        /**
         * The email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var emailAddress: kotlin.String? = null
        /**
         * The first name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var firstName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM Identity Center instance.
         */
        public var iamIdentityCenterInstanceArn: kotlin.String? = null
        /**
         * The last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var lastName: kotlin.String? = null
        /**
         * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
         */
        public var notificationEmail: kotlin.String? = null
        /**
         * The reader group associated with your Active Directory or IAM Identity Center account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var readerGroup: List<String>? = null
        /**
         * The reader pro group associated with your Active Directory or IAM Identity Center account.
         *
         * For more information about using IAM Identity Center in Amazon QuickSight, see [Using IAM Identity Center with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html) in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var readerProGroup: List<String>? = null
        /**
         * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
         */
        public var realm: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest) : this() {
            this.accountName = x.accountName
            this.activeDirectoryName = x.activeDirectoryName
            this.adminGroup = x.adminGroup
            this.adminProGroup = x.adminProGroup
            this.authenticationMethod = x.authenticationMethod
            this.authorGroup = x.authorGroup
            this.authorProGroup = x.authorProGroup
            this.awsAccountId = x.awsAccountId
            this.contactNumber = x.contactNumber
            this.directoryId = x.directoryId
            this.edition = x.edition
            this.emailAddress = x.emailAddress
            this.firstName = x.firstName
            this.iamIdentityCenterInstanceArn = x.iamIdentityCenterInstanceArn
            this.lastName = x.lastName
            this.notificationEmail = x.notificationEmail
            this.readerGroup = x.readerGroup
            this.readerProGroup = x.readerProGroup
            this.realm = x.realm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = CreateAccountSubscriptionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
