// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of a `ComboChartVisual`.
 */
public class ComboChartConfiguration private constructor(builder: Builder) {
    /**
     * The options that determine if visual data labels are displayed.
     *
     * The data label options for a bar in a combo chart.
     */
    public val barDataLabels: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions? = builder.barDataLabels
    /**
     * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
     * + `CLUSTERED`: For clustered bar combo charts.
     * + `STACKED`: For stacked bar combo charts.
     * + `STACKED_PERCENT`: Do not use. If you use this value, the operation returns a validation error.
     */
    public val barsArrangement: aws.sdk.kotlin.services.quicksight.model.BarsArrangement? = builder.barsArrangement
    /**
     * The category axis of a combo chart.
     */
    public val categoryAxis: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = builder.categoryAxis
    /**
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
     */
    public val categoryLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = builder.categoryLabelOptions
    /**
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
     */
    public val colorLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = builder.colorLabelOptions
    /**
     * The field wells of the visual.
     */
    public val fieldWells: aws.sdk.kotlin.services.quicksight.model.ComboChartFieldWells? = builder.fieldWells
    /**
     * The general visual interactions setup for a visual.
     */
    public val interactions: aws.sdk.kotlin.services.quicksight.model.VisualInteractionOptions? = builder.interactions
    /**
     * The legend display setup of the visual.
     */
    public val legend: aws.sdk.kotlin.services.quicksight.model.LegendOptions? = builder.legend
    /**
     * The options that determine if visual data labels are displayed.
     *
     * The data label options for a line in a combo chart.
     */
    public val lineDataLabels: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions? = builder.lineDataLabels
    /**
     * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
     */
    public val primaryYAxisDisplayOptions: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = builder.primaryYAxisDisplayOptions
    /**
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
     */
    public val primaryYAxisLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = builder.primaryYAxisLabelOptions
    /**
     * The reference line setup of the visual.
     */
    public val referenceLines: List<ReferenceLine>? = builder.referenceLines
    /**
     * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
     */
    public val secondaryYAxisDisplayOptions: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = builder.secondaryYAxisDisplayOptions
    /**
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
     */
    public val secondaryYAxisLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = builder.secondaryYAxisLabelOptions
    /**
     * The settings of a chart's single axis configuration.
     */
    public val singleAxisOptions: aws.sdk.kotlin.services.quicksight.model.SingleAxisOptions? = builder.singleAxisOptions
    /**
     * The sort configuration of a `ComboChartVisual`.
     */
    public val sortConfiguration: aws.sdk.kotlin.services.quicksight.model.ComboChartSortConfiguration? = builder.sortConfiguration
    /**
     * The legend display setup of the visual.
     */
    public val tooltip: aws.sdk.kotlin.services.quicksight.model.TooltipOptions? = builder.tooltip
    /**
     * The palette (chart color) display setup of the visual.
     */
    public val visualPalette: aws.sdk.kotlin.services.quicksight.model.VisualPalette? = builder.visualPalette

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ComboChartConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComboChartConfiguration(")
        append("barDataLabels=$barDataLabels,")
        append("barsArrangement=$barsArrangement,")
        append("categoryAxis=$categoryAxis,")
        append("categoryLabelOptions=$categoryLabelOptions,")
        append("colorLabelOptions=$colorLabelOptions,")
        append("fieldWells=$fieldWells,")
        append("interactions=$interactions,")
        append("legend=$legend,")
        append("lineDataLabels=$lineDataLabels,")
        append("primaryYAxisDisplayOptions=$primaryYAxisDisplayOptions,")
        append("primaryYAxisLabelOptions=$primaryYAxisLabelOptions,")
        append("referenceLines=$referenceLines,")
        append("secondaryYAxisDisplayOptions=$secondaryYAxisDisplayOptions,")
        append("secondaryYAxisLabelOptions=$secondaryYAxisLabelOptions,")
        append("singleAxisOptions=$singleAxisOptions,")
        append("sortConfiguration=$sortConfiguration,")
        append("tooltip=$tooltip,")
        append("visualPalette=$visualPalette")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = barDataLabels?.hashCode() ?: 0
        result = 31 * result + (barsArrangement?.hashCode() ?: 0)
        result = 31 * result + (categoryAxis?.hashCode() ?: 0)
        result = 31 * result + (categoryLabelOptions?.hashCode() ?: 0)
        result = 31 * result + (colorLabelOptions?.hashCode() ?: 0)
        result = 31 * result + (fieldWells?.hashCode() ?: 0)
        result = 31 * result + (interactions?.hashCode() ?: 0)
        result = 31 * result + (legend?.hashCode() ?: 0)
        result = 31 * result + (lineDataLabels?.hashCode() ?: 0)
        result = 31 * result + (primaryYAxisDisplayOptions?.hashCode() ?: 0)
        result = 31 * result + (primaryYAxisLabelOptions?.hashCode() ?: 0)
        result = 31 * result + (referenceLines?.hashCode() ?: 0)
        result = 31 * result + (secondaryYAxisDisplayOptions?.hashCode() ?: 0)
        result = 31 * result + (secondaryYAxisLabelOptions?.hashCode() ?: 0)
        result = 31 * result + (singleAxisOptions?.hashCode() ?: 0)
        result = 31 * result + (sortConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tooltip?.hashCode() ?: 0)
        result = 31 * result + (visualPalette?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComboChartConfiguration

        if (barDataLabels != other.barDataLabels) return false
        if (barsArrangement != other.barsArrangement) return false
        if (categoryAxis != other.categoryAxis) return false
        if (categoryLabelOptions != other.categoryLabelOptions) return false
        if (colorLabelOptions != other.colorLabelOptions) return false
        if (fieldWells != other.fieldWells) return false
        if (interactions != other.interactions) return false
        if (legend != other.legend) return false
        if (lineDataLabels != other.lineDataLabels) return false
        if (primaryYAxisDisplayOptions != other.primaryYAxisDisplayOptions) return false
        if (primaryYAxisLabelOptions != other.primaryYAxisLabelOptions) return false
        if (referenceLines != other.referenceLines) return false
        if (secondaryYAxisDisplayOptions != other.secondaryYAxisDisplayOptions) return false
        if (secondaryYAxisLabelOptions != other.secondaryYAxisLabelOptions) return false
        if (singleAxisOptions != other.singleAxisOptions) return false
        if (sortConfiguration != other.sortConfiguration) return false
        if (tooltip != other.tooltip) return false
        if (visualPalette != other.visualPalette) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ComboChartConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The options that determine if visual data labels are displayed.
         *
         * The data label options for a bar in a combo chart.
         */
        public var barDataLabels: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions? = null
        /**
         * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
         * + `CLUSTERED`: For clustered bar combo charts.
         * + `STACKED`: For stacked bar combo charts.
         * + `STACKED_PERCENT`: Do not use. If you use this value, the operation returns a validation error.
         */
        public var barsArrangement: aws.sdk.kotlin.services.quicksight.model.BarsArrangement? = null
        /**
         * The category axis of a combo chart.
         */
        public var categoryAxis: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = null
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
         */
        public var categoryLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = null
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
         */
        public var colorLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = null
        /**
         * The field wells of the visual.
         */
        public var fieldWells: aws.sdk.kotlin.services.quicksight.model.ComboChartFieldWells? = null
        /**
         * The general visual interactions setup for a visual.
         */
        public var interactions: aws.sdk.kotlin.services.quicksight.model.VisualInteractionOptions? = null
        /**
         * The legend display setup of the visual.
         */
        public var legend: aws.sdk.kotlin.services.quicksight.model.LegendOptions? = null
        /**
         * The options that determine if visual data labels are displayed.
         *
         * The data label options for a line in a combo chart.
         */
        public var lineDataLabels: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions? = null
        /**
         * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
         */
        public var primaryYAxisDisplayOptions: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = null
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
         */
        public var primaryYAxisLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = null
        /**
         * The reference line setup of the visual.
         */
        public var referenceLines: List<ReferenceLine>? = null
        /**
         * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
         */
        public var secondaryYAxisDisplayOptions: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions? = null
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
         */
        public var secondaryYAxisLabelOptions: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions? = null
        /**
         * The settings of a chart's single axis configuration.
         */
        public var singleAxisOptions: aws.sdk.kotlin.services.quicksight.model.SingleAxisOptions? = null
        /**
         * The sort configuration of a `ComboChartVisual`.
         */
        public var sortConfiguration: aws.sdk.kotlin.services.quicksight.model.ComboChartSortConfiguration? = null
        /**
         * The legend display setup of the visual.
         */
        public var tooltip: aws.sdk.kotlin.services.quicksight.model.TooltipOptions? = null
        /**
         * The palette (chart color) display setup of the visual.
         */
        public var visualPalette: aws.sdk.kotlin.services.quicksight.model.VisualPalette? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ComboChartConfiguration) : this() {
            this.barDataLabels = x.barDataLabels
            this.barsArrangement = x.barsArrangement
            this.categoryAxis = x.categoryAxis
            this.categoryLabelOptions = x.categoryLabelOptions
            this.colorLabelOptions = x.colorLabelOptions
            this.fieldWells = x.fieldWells
            this.interactions = x.interactions
            this.legend = x.legend
            this.lineDataLabels = x.lineDataLabels
            this.primaryYAxisDisplayOptions = x.primaryYAxisDisplayOptions
            this.primaryYAxisLabelOptions = x.primaryYAxisLabelOptions
            this.referenceLines = x.referenceLines
            this.secondaryYAxisDisplayOptions = x.secondaryYAxisDisplayOptions
            this.secondaryYAxisLabelOptions = x.secondaryYAxisLabelOptions
            this.singleAxisOptions = x.singleAxisOptions
            this.sortConfiguration = x.sortConfiguration
            this.tooltip = x.tooltip
            this.visualPalette = x.visualPalette
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ComboChartConfiguration = ComboChartConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataLabelOptions] inside the given [block]
         */
        public fun barDataLabels(block: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions.Builder.() -> kotlin.Unit) {
            this.barDataLabels = aws.sdk.kotlin.services.quicksight.model.DataLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions] inside the given [block]
         */
        public fun categoryAxis(block: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.Builder.() -> kotlin.Unit) {
            this.categoryAxis = aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions] inside the given [block]
         */
        public fun categoryLabelOptions(block: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.Builder.() -> kotlin.Unit) {
            this.categoryLabelOptions = aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions] inside the given [block]
         */
        public fun colorLabelOptions(block: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.Builder.() -> kotlin.Unit) {
            this.colorLabelOptions = aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ComboChartFieldWells] inside the given [block]
         */
        public fun fieldWells(block: aws.sdk.kotlin.services.quicksight.model.ComboChartFieldWells.Builder.() -> kotlin.Unit) {
            this.fieldWells = aws.sdk.kotlin.services.quicksight.model.ComboChartFieldWells.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualInteractionOptions] inside the given [block]
         */
        public fun interactions(block: aws.sdk.kotlin.services.quicksight.model.VisualInteractionOptions.Builder.() -> kotlin.Unit) {
            this.interactions = aws.sdk.kotlin.services.quicksight.model.VisualInteractionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.LegendOptions] inside the given [block]
         */
        public fun legend(block: aws.sdk.kotlin.services.quicksight.model.LegendOptions.Builder.() -> kotlin.Unit) {
            this.legend = aws.sdk.kotlin.services.quicksight.model.LegendOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataLabelOptions] inside the given [block]
         */
        public fun lineDataLabels(block: aws.sdk.kotlin.services.quicksight.model.DataLabelOptions.Builder.() -> kotlin.Unit) {
            this.lineDataLabels = aws.sdk.kotlin.services.quicksight.model.DataLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions] inside the given [block]
         */
        public fun primaryYAxisDisplayOptions(block: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.Builder.() -> kotlin.Unit) {
            this.primaryYAxisDisplayOptions = aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions] inside the given [block]
         */
        public fun primaryYAxisLabelOptions(block: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.Builder.() -> kotlin.Unit) {
            this.primaryYAxisLabelOptions = aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions] inside the given [block]
         */
        public fun secondaryYAxisDisplayOptions(block: aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.Builder.() -> kotlin.Unit) {
            this.secondaryYAxisDisplayOptions = aws.sdk.kotlin.services.quicksight.model.AxisDisplayOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions] inside the given [block]
         */
        public fun secondaryYAxisLabelOptions(block: aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.Builder.() -> kotlin.Unit) {
            this.secondaryYAxisLabelOptions = aws.sdk.kotlin.services.quicksight.model.ChartAxisLabelOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SingleAxisOptions] inside the given [block]
         */
        public fun singleAxisOptions(block: aws.sdk.kotlin.services.quicksight.model.SingleAxisOptions.Builder.() -> kotlin.Unit) {
            this.singleAxisOptions = aws.sdk.kotlin.services.quicksight.model.SingleAxisOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ComboChartSortConfiguration] inside the given [block]
         */
        public fun sortConfiguration(block: aws.sdk.kotlin.services.quicksight.model.ComboChartSortConfiguration.Builder.() -> kotlin.Unit) {
            this.sortConfiguration = aws.sdk.kotlin.services.quicksight.model.ComboChartSortConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TooltipOptions] inside the given [block]
         */
        public fun tooltip(block: aws.sdk.kotlin.services.quicksight.model.TooltipOptions.Builder.() -> kotlin.Unit) {
            this.tooltip = aws.sdk.kotlin.services.quicksight.model.TooltipOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualPalette] inside the given [block]
         */
        public fun visualPalette(block: aws.sdk.kotlin.services.quicksight.model.VisualPalette.Builder.() -> kotlin.Unit) {
            this.visualPalette = aws.sdk.kotlin.services.quicksight.model.VisualPalette.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
