// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `CategoryFilter` filters text values.
 *
 * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide*.
 */
public class CategoryFilter private constructor(builder: Builder) {
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The configuration for a `CategoryFilter`.
     */
    public val configuration: aws.sdk.kotlin.services.quicksight.model.CategoryFilterConfiguration? = builder.configuration
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CategoryFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CategoryFilter(")
        append("column=$column,")
        append("configuration=$configuration,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("filterId=$filterId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CategoryFilter

        if (column != other.column) return false
        if (configuration != other.configuration) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (filterId != other.filterId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CategoryFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The configuration for a `CategoryFilter`.
         */
        public var configuration: aws.sdk.kotlin.services.quicksight.model.CategoryFilterConfiguration? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CategoryFilter) : this() {
            this.column = x.column
            this.configuration = x.configuration
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.filterId = x.filterId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CategoryFilter = CategoryFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.CategoryFilterConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.quicksight.model.CategoryFilterConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.quicksight.model.CategoryFilterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            return this
        }
    }
}
