// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the brand.
 */
public class BrandDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the brand.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ID of the Amazon QuickSight brand.
     */
    public val brandId: kotlin.String = requireNotNull(builder.brandId) { "A non-null value must be provided for brandId" }
    /**
     * The status of the brand.
     */
    public val brandStatus: aws.sdk.kotlin.services.quicksight.model.BrandStatus? = builder.brandStatus
    /**
     * The time that the brand was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A list of errors that occurred during the most recent brand operation.
     */
    public val errors: List<String>? = builder.errors
    /**
     * The last time the brand was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The logo details.
     */
    public val logo: aws.sdk.kotlin.services.quicksight.model.Logo? = builder.logo
    /**
     * The ID of the version.
     */
    public val versionId: kotlin.String? = builder.versionId
    /**
     * The status of the version.
     */
    public val versionStatus: aws.sdk.kotlin.services.quicksight.model.BrandVersionStatus? = builder.versionStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.BrandDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BrandDetail(")
        append("arn=$arn,")
        append("brandId=$brandId,")
        append("brandStatus=$brandStatus,")
        append("createdTime=$createdTime,")
        append("errors=$errors,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("logo=$logo,")
        append("versionId=$versionId,")
        append("versionStatus=$versionStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (brandId.hashCode())
        result = 31 * result + (brandStatus?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (logo?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (versionStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BrandDetail

        if (arn != other.arn) return false
        if (brandId != other.brandId) return false
        if (brandStatus != other.brandStatus) return false
        if (createdTime != other.createdTime) return false
        if (errors != other.errors) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (logo != other.logo) return false
        if (versionId != other.versionId) return false
        if (versionStatus != other.versionStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.BrandDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the brand.
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the Amazon QuickSight brand.
         */
        public var brandId: kotlin.String? = null
        /**
         * The status of the brand.
         */
        public var brandStatus: aws.sdk.kotlin.services.quicksight.model.BrandStatus? = null
        /**
         * The time that the brand was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of errors that occurred during the most recent brand operation.
         */
        public var errors: List<String>? = null
        /**
         * The last time the brand was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The logo details.
         */
        public var logo: aws.sdk.kotlin.services.quicksight.model.Logo? = null
        /**
         * The ID of the version.
         */
        public var versionId: kotlin.String? = null
        /**
         * The status of the version.
         */
        public var versionStatus: aws.sdk.kotlin.services.quicksight.model.BrandVersionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.BrandDetail) : this() {
            this.arn = x.arn
            this.brandId = x.brandId
            this.brandStatus = x.brandStatus
            this.createdTime = x.createdTime
            this.errors = x.errors
            this.lastUpdatedTime = x.lastUpdatedTime
            this.logo = x.logo
            this.versionId = x.versionId
            this.versionStatus = x.versionStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.BrandDetail = BrandDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Logo] inside the given [block]
         */
        public fun logo(block: aws.sdk.kotlin.services.quicksight.model.Logo.Builder.() -> kotlin.Unit) {
            this.logo = aws.sdk.kotlin.services.quicksight.model.Logo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (brandId == null) brandId = ""
            return this
        }
    }
}
