// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Parameters for Amazon Athena.
 */
public class AthenaParameters private constructor(builder: Builder) {
    /**
     * An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your workgroup.
     *
     * This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
     */
    public val identityCenterConfiguration: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration? = builder.identityCenterConfiguration
    /**
     * Use the `RoleArn` structure to override an account-wide role for a specific Athena data source. For example, say an account administrator has turned off all Athena access with an account-wide role. The administrator can then use `RoleArn` to bypass the account-wide role and allow Athena access for the single Athena data source that is specified in the structure, even if the account-wide role forbidding Athena access is still active.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The workgroup that Amazon Athena uses.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AthenaParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AthenaParameters(")
        append("identityCenterConfiguration=$identityCenterConfiguration,")
        append("roleArn=$roleArn,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityCenterConfiguration?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AthenaParameters

        if (identityCenterConfiguration != other.identityCenterConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AthenaParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your workgroup.
         *
         * This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
         */
        public var identityCenterConfiguration: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration? = null
        /**
         * Use the `RoleArn` structure to override an account-wide role for a specific Athena data source. For example, say an account administrator has turned off all Athena access with an account-wide role. The administrator can then use `RoleArn` to bypass the account-wide role and allow Athena access for the single Athena data source that is specified in the structure, even if the account-wide role forbidding Athena access is still active.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The workgroup that Amazon Athena uses.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AthenaParameters) : this() {
            this.identityCenterConfiguration = x.identityCenterConfiguration
            this.roleArn = x.roleArn
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AthenaParameters = AthenaParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration] inside the given [block]
         */
        public fun identityCenterConfiguration(block: aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration.Builder.() -> kotlin.Unit) {
            this.identityCenterConfiguration = aws.sdk.kotlin.services.quicksight.model.IdentityCenterConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
